--
--  selection.lua (work_phase_actual)
local dqry = require "dqry"
local dload = require "dload"
local util = require "util"
local json = require "json"
local dt = require "dt"
local uuid = require "uuid"
local l = require"lang".l
local peg = require "peg"
local auth = require "auth"
local plg4d
if util.from4d() then
	plg4d = require "plg4d"
end

local function saveSelection(paramTbl)
	local newPrfName = ""
	local err
	if not paramTbl then
		err = l("parameter is missing")
		-- elseif type(paramTbl.record_id) ~= "table" then
		-- err = l"parameter record_id is not a table"
	elseif not (paramTbl.user or paramTbl.login_id) then
		err = l("parameter user or login_id is missing")
	else
		if util.from4d() and paramTbl.record_id and #paramTbl.record_id > 200 then
			local continue = plg4d.confirm(l("Big selection (%d records) can cause problems. Do you still want to use the selection?", #paramTbl.record_id))
			if continue ~= true then
				return ""
			end
		end
		-- local conn = dconn.option()
		-- if conn then
		local validUntil = dt.toString(dt.secondsAdd(dt.currentDateTime(), 30 * 60))
		local authToken = uuid.new()
		local user = paramTbl.user or paramTbl.login_id
		if paramTbl.table then
			paramTbl.user = nil
		end

		local session = {
			session_id = authToken,
			login_id = user,
			valid_until = validUntil,
			-- organization_id = 0, --userPref.default_organization_id,
			json_data = json.toJsonRaw(paramTbl) -- .record_id) -- {record_id = json.toJsonRaw(paramTbl.record_id)},
		}
		err = auth.saveAuthRecord(session)
		newPrfName = authToken
		-- end
		if err then
			err = peg.replace(err, "'", "")
			err = peg.replace(err, '\\"', "")
			err = peg.replace(err, '"', "")
			newPrfName = ""
		end
	end
	if util.from4d() then
		newPrfName = "?id=" .. newPrfName -- return url path end
	end

	-- print("newPrfName: "..newPrfName)
	return newPrfName, err
end

local function loadSelection(sessionId)
	local ret = {}
	if sessionId and sessionId ~= "" then
		-- local conn = dconn.option() -- 4d
		-- if conn then
		dqry.query("", "ses.session_id", "=", sessionId, "")
		local sel = dload.selectionToRecordArray({"ses.json_data"})
		if sel ~= nil and #sel == 1 and sel[1].json_data then
			ret = json.fromJson(sel[1].json_data)
			-- local sessionJsonData = json.fromJson(sel[1].json_data)
			-- if sessionJsonData.record_id ~= nil then
			--	ret = sessionJsonData.record_id
			-- end
		end
		-- end
	end
	return ret -- {data=ret}
end

return {saveSelection = saveSelection, loadSelection = loadSelection}
