---  serialize.lua
--
--  Author: Pasi Mankinen
--
module(..., package.seeall)

-- local ma = require "util" -- "lib/ma_lib"

local json, mpack
local usejson = 0 -- cjson == 0
local usempack = 0 --6 -- 0

local cbor = require "cbor"
function fromCbor(data)
	return cbor.decode(data)
end

function toCbor(data)
	return cbor.encode(data)
end
	
function setJsonLib(num)
	usejson = num
end

if usejson == 0 then 
	json = require "cjson"
	json.encode_empty_table_as_object(false) -- Lua {} -> json "[]"
elseif usejson == 1 then 
	json = require "JSON" -- pure-lua version
elseif usejson == 2 then 
	json = require "dkjson" -- pure-lua version
elseif usejson == 3 then 
	json = require "test/libcjson.lua"
end

function printJsonLibName()
	if usejson == 0 then 
		print("using cjson")
	elseif usejson == 1 then
		print("using JSON")
	elseif usejson == 2 then
		print("using dkjson")
	elseif usejson == 3 then
		print("using resty-libcjson")
	end
end


function fromJson(data)
	if usejson == 1 then
		return json:decode(data)
	else
		return json.decode(data)
	end
end

function toJson(data, pretty)
  pretty = pretty or false
	if usejson == 0 then
		return json.encode(data)
	elseif usejson == 1 then
		local outDatajson = json:encode(data)
		if outDatajson == "[]" then 
			outDatajson = "{}"
		end
		return outDatajson
	elseif usejson == 2 then
		return json.encode(data, {indent = pretty}) -- dkjson, http://dkolf.de/src/dkjson-lua.fsl/wiki?name=Documentation
	elseif usejson == 3 then
		return json.encode(data)
	end
end

-- mpack


if usempack == 6 then
	mpack = require "cmsgpack" -- C-code
elseif usempack == 5 then
	mpack = require "fleece" -- only out
elseif usempack == 4 then
	mpack = require "marshal" -- ok
elseif usempack == 3 then
	mpack = require "luatexts" -- ??
elseif usempack == 2 then
	mpack = require "luabins" -- does not work?
elseif usempack == 1 then
	mpack = require "MessagePack" -- pure-lua version
elseif usempack == 0 then
	mpack = require "luajit-msgpack-pure" -- luajit version
else
	--
end
	
	
	
function printMpackLibName()
	if usempack == 6 then
		print("using cmsgpack")
	elseif usempack == 5 then
		print("using fleece")
	elseif usempack == 4 then
		print("using marshal")
	elseif usempack == 3 then
		print("using luatexts")
	elseif usempack == 2 then
		print("using luabins")
	elseif usempack == 1 then
		print("using MessagePack")
	elseif usempack == 0 then
		print("using luajit-msgpack-pure")
	else
		--
	end
end

function fromMpack(data)
	if usempack == 6 then
		return mpack.unpack(data)
	elseif usempack == 5 then
		print("fleece decode not supported")
		return "null"
	elseif usempack == 4 then
		return mpack.decode(data)
	elseif usempack == 3 then
		return mpack.load(data)
	elseif usempack == 2 then
		return mpack.load(data)
	elseif  usempack == 1 then
		return mpack.unpack(data)
	elseif usempack == 0 then
		local offset,decoded = mpack.unpack(data)
		return decoded
	else
		--
	end
end

function toMpack(data)	
	if usempack == 6 then
		return mpack.pack(data)
	elseif usempack == 5 then
		return mpack.json(data)
	elseif usempack == 4 then
		return mpack.encode(data)
	elseif usempack == 3 then
		return mpack.save(data)
	elseif usempack == 2 then
		return mpack.save(data)
	elseif usempack == 1 then
		return mpack.pack(data)
	elseif usempack == 0 then
		return mpack.pack(data)
	else
		--
	end
end
