-- start.lua
--[[
Try to turn off trace stitching:
 require("jit.opt").start("minstitch=10000")

function trace (event, line) -- event will be "line" here
  local s = debug.getinfo(2).short_src
  io.write(s .. ":" .. line)
  io.flush()
end
debug.sethook(trace, 'l')
--]] --
do
	local ok, jitOpt = pcall(require, 'jit.opt')
	if ok then -- from jit mailing list, subject: Re: 2.1 regresion?
		-- jitOpt.start('maxtrace=8000', 'maxrecord=16000', 'minstitch=3', 'maxmcode=40960')  -- maxmcode in KB, these are openresty defaults
		jitOpt.start("maxtrace=100000", "maxrecord=40000", "maxside=1000", "sizemcode=256", "maxmcode=81920", "minstitch=3", "loopunroll=7") -- see mailing list: Re: [SOLVED] Inexplicable behaviour of JIT
	end
end
-- ]]

unpack = table.unpack or unpack -- luacheck: no global
table.unpack = unpack -- luacheck: no global
if not jit then
	package.cpath = "?.so;?.dll;" .. package.cpath -- needed for ffi.so
end
local ffi = require "ffi"
local C = ffi.C -- may be overridden later in windows in plg4d.init
local loc = {}
loc.from4d = false
loc.c4d = C -- global dll ref, created by ffi.load() in windows
loc.pathFile = ""
loc.prefixPath = ""
loc.param = ""
loc.pathBin = ""
loc.path4d = ""
loc.startPath = ""
loc.userName = ""
local plg4d -- later: require "plg4d"
local oldAssert = assert

--[[
local collectGarbageOrig = collectgarbage
collectgarbage = function(...)
	return collectGarbageOrig(...)
end -- ]]

-- remove trailing whitespace from string.
-- http://en.wikipedia.org/wiki/Trim_(programming)
local function rtrim(s, sep)
	local n = #s
	while n > 0 and s:sub(n, n) ~= sep do
		n = n - 1
	end
	return s:sub(1, n - 1)
end

local function cmd(command)
	local file = io.popen(command)
	if file == nil then
		print("*** ERROR running command: " .. command)
		return "err: error in running command: " .. command
	end
	local ret = file:read("*a")
	file:close()
	return ret:gsub("\n", "")
end

--- Check if a file or directory exists in this path
local function exists(file)
	local ok, err, code = os.rename(file, file)
	if not ok then
		if code == 13 then
			-- Permission denied, but it exists
			return true
		elseif code == 18 then
			-- "/Volumes/nc: Cross-device link"
			return true
		end
	end
	return ok, err
end

if ffi.os == "Windows" then
	loc.userName = cmd("echo %USERNAME%") -- ﻿echo %USERDOMAIN%\%USERNAME% - ﻿SET USERNAME
	loc.startPath = cmd("cd"):gsub("\\", "/") .. "/" -- cd without param is same as pwd in unix
else
	-- os.setlocale("fi_FI")
	loc.userName = cmd("whoami")
	loc.startPath = cmd("pwd") .. "/"
	-- if loc.startPath:sub(1, 9):lower() == "/volumes/" then
	-- 	loc.startPath = "/Users/" .. loc.userName .. "/" .. loc.startPath:sub(10)
	-- end
end

if not loc.from4d then
	print("* user name: " .. loc.userName .. ", system: " .. ffi.os .. " " .. ffi.arch)
	print("* start path: " .. loc.startPath)
end

local lfs

local function loadlLfs(showError)
	local ok
	ok, lfs = pcall(require, "lfs_load") -- must be after setting path
	if not ok then
		if showError then
			print("lfs_load require error, version: " .. tostring(lfs._VERSION))
		end
		return
	end
	print("* file library version: " .. tostring(lfs._VERSION))
end

local function setBinPath(path, showError)
	local ok, err
	showError = showError ~= false
	local binPathEnd = "bin_" .. ffi.os:lower():gsub("windows", "win") .. "_" .. ffi.arch .. "/"
	if lfs == nil then
		package.cpath = "../bin/" .. binPathEnd .. "?.so;" .. package.cpath
		package.cpath = "../bin/" .. binPathEnd .. "?.dll;" .. package.cpath
		package.cpath = "../bin/" .. binPathEnd .. "?.dylib;" .. package.cpath
		package.path = "?.lua;?.lx;" .. package.path
		ok, err = pcall(require, "ffi_def") -- must be after setting path
		if not ok then
			local err2
			ok, err2 = pcall(require, "lib/ffi_def")
			if not ok then
				if showError then
					print("ffi_def require error: '" .. tostring(err) .. "', error 2: '" .. tostring(err2) .. "'") -- show first pcall error, second may be loop load error
				end
				return
			end
		end
		loadlLfs(showError)
	end
	local currentDir
	if path ~= "" then
		currentDir = path
	elseif lfs and lfs.currentdir then
		currentDir = lfs.currentdir()
		if ffi.os == "Windows" then
			currentDir = currentDir:gsub("\\", "/")
		end
	else
		currentDir = loc.startPath
	end
	-- print("* start current directory: "..currentDir)
	if not currentDir:find("Manageri_v12.4dbase", 1, true) then
		loc.pathBin = currentDir .. "/bin/" .. binPathEnd
		ok = lfs.attributes(loc.pathBin:sub(1, -2)) -- remove trailig "/" for lfs
		if not ok then
			currentDir = rtrim(currentDir, "/")
			loc.pathBin = currentDir .. "/bin/" .. binPathEnd
			ok = lfs.attributes(loc.pathBin:sub(1, -2)) -- remove trailig "/" for lfs
			if not ok then
				currentDir = rtrim(currentDir, "/")
				-- print("currentDir 3: "..currentDir)
				loc.pathBin = currentDir .. "/bin/" .. binPathEnd
				ok = lfs.attributes(loc.pathBin:sub(1, -2))
				if not ok then
					currentDir = rtrim(currentDir, "/")
					-- print("currentDir 4: "..currentDir)
					loc.pathBin = currentDir .. "/bin/" .. binPathEnd
					ok = lfs.attributes(loc.pathBin:sub(1, -2))
				end
			end
		end
	end
	if not ok then
		loc.pathBin = "../bin/bin_" .. ffi.os:lower():gsub("windows", "win") .. "_" .. ffi.arch .. "/" -- restore first quess
		if showError then
			print("*** start error, pathBin is not corret ***: " .. loc.pathBin)
		end
		-- elseif showError then
		-- print("* pathBin: " .. loc.pathBin)
	end
end
setBinPath("", false)

local volumesNc = exists("/Volumes/nc")
local function setFilePath(prefixPath, showError)
	if prefixPath == "~/nc/nc-server/" or prefixPath == "/Volumes/nc/nc-server/" then
		if lfs == nil then
			loadlLfs(showError)
		end
		if lfs and lfs.currentdir then
			local currentDir = lfs.currentdir()
			if string.find(currentDir, "/nc-server-dist", 1, true) then
				return
			end
			if lfs.attributes(prefixPath) == nil and lfs.attributes(prefixPath:sub(1, -2)) == nil then -- test if prefixPath does not exist, test also by removing last "/"
				prefixPath = currentDir .. "/"
			end
		end
	end
	if loc.pathFile == "" and prefixPath ~= "" then
		loc.startPath = loc.startPath:gsub("\\", "/")
		if prefixPath:sub(1, 12) == "/Volumes/nc/" and ffi.os == "Windows" then
			prefixPath = prefixPath:gsub("/Volumes/nc/", "C:/nc/")
		end
		if prefixPath:sub(1, 1) == "~" then
			if volumesNc and prefixPath:sub(1, 5) == "~/nc/" then
				prefixPath = "/Volumes/nc/" .. prefixPath:sub(6)
				if lfs == nil or lfs.attributes(prefixPath) == nil and loc.startPath:find("/nc-backend/", 1, true) then
					prefixPath = prefixPath:gsub("nc%-server/", "nc-server-dist/")
				end
				if loc.startPath:find("/nc-server-dist/", 1, true) then
					prefixPath = prefixPath:gsub("nc%-server/", "nc-server-dist/")
				end
			else
				prefixPath = prefixPath:sub(2)
			end
			-- loc.pathFile = prefixPath
			local pos = loc.startPath:find(prefixPath, 1, true)
			if pos == nil then
				loc.startPath = loc.startPath:gsub("nc%-plugin", "nc-server")
				pos = loc.startPath:find(prefixPath, 1, true)
				if pos == nil and loc.startPath:find("nc%-devops") then
					showError = false
				end
			end
			if pos then
				prefixPath = loc.startPath:sub(1, pos - 1) .. prefixPath
			else
				if showError then
					print(string.format("* prefixPath '%s' was not found from loc.startPath '%s'", tostring(prefixPath), tostring(loc.startPath)))
				end
			end
		else
			loc.pathFile = prefixPath
		end
		loc.prefixPath = prefixPath
		-- elseif loc.pathFile == "" then
		-- loc.pathFile = loc.startPath
	end
	local path = ""
	path = path .. prefixPath .. "?.lua;" .. prefixPath .. "?.lx;"
	path = path .. prefixPath .. "../?.lua;" .. prefixPath .. "../?.lx;"
	path = path .. prefixPath .. "../../?.lua;" .. prefixPath .. "../../?.lx;"
	path = path .. prefixPath .. "../../../?.lua;" .. prefixPath .. "../../../?.lx;" -- handles ../custom/xxx

	path = path .. prefixPath .. "lib/?.lua;" .. prefixPath .. "lib/?.lx;"
	path = path .. prefixPath .. "lib/db/?.lua;" .. prefixPath .. "lib/db/?.lx;"
	path = path .. prefixPath .. "lib/?/init.lua;" .. prefixPath .. "lib/?/init.lx;"
	path = path .. prefixPath .. "lib/?/?.lua;" .. prefixPath .. "lib/?/?.lx;"
	path = path .. prefixPath .. "../lib/?.lua;" .. prefixPath .. "../lib/?.lx;"
	path = path .. prefixPath .. "../lib/db/?.lua;" .. prefixPath .. "../lib/db/?.lx;"
	path = path .. prefixPath .. "../lib/?/init.lua;" .. prefixPath .. "../lib/?/init.lx;"
	path = path .. prefixPath .. "../lib/?/?.lua;" .. prefixPath .. "../lib/?/?.lx;"
	path = path .. prefixPath .. "../../lib/?.lua;" .. prefixPath .. "../../lib/?.lx;"
	path = path .. prefixPath .. "../../lib/db/?.lua;" .. prefixPath .. "../../lib/db/?.lx;"
	path = path .. prefixPath .. "../../lib/?/init.lua;" .. prefixPath .. "../../lib/?/init.lx;"
	path = path .. prefixPath .. "../../lib/?/?.lua;" .. prefixPath .. "../../lib/?/?.lx;"

	path = path .. prefixPath .. "../nc-server/lib/?.lua;" .. prefixPath .. "../nc-server/lib/?.lx;" -- from custom
	path = path .. prefixPath .. "../nc-server/lib/db/?.lua;" .. prefixPath .. "../nc-server/lib/db/?.lx;"
	path = path .. prefixPath .. "../nc-server/lib/?/init.lua;" .. prefixPath .. "../nc-server/lib/?/init.lx;"
	path = path .. prefixPath .. "../nc-server/lib/?/?.lua;" .. prefixPath .. "../nc-server/lib/?/?.lx;"
	path = path .. prefixPath .. "../../nc-server/lib/?.lua;" .. prefixPath .. "../../nc-server/lib/?.lx;"
	path = path .. prefixPath .. "../../nc-server/lib/db/?.lua;" .. prefixPath .. "../../nc-server/lib/db/?.lx;"
	path = path .. prefixPath .. "../../nc-server/lib/?/init.lua;" .. prefixPath .. "../../nc-server/lib/?/init.lx;"
	path = path .. prefixPath .. "../../nc-server/lib/?/?.lua;" .. prefixPath .. "../../nc-server/lib/?/?.lx;"

	path = path .. prefixPath .. "tool/lib/?.lua;" .. prefixPath .. "tool/lib/?.lx;"
	path = path .. prefixPath .. "tool/lib/?/init.lua;" .. prefixPath .. "tool/lib/?/init.lx;"
	path = path .. prefixPath .. "tool/lib/?/?.lua;" .. prefixPath .. "tool/lib/?/?.lx;"

	path = path .. prefixPath .. "nc/?.lua;" .. prefixPath .. "nc/?.lx;"
	path = path .. prefixPath .. "../nc/?.lua;" .. prefixPath .. "../nc/?.lx;"
	path = path .. prefixPath .. "../../nc/?.lua;" .. prefixPath .. "../../nc/?.lx;"
	-- load lua files from nc-plugin
	path = path .. prefixPath .. "../nc-plugin/?.lua;" .. prefixPath .. "../nc-plugin/?.lx;"
	path = path .. prefixPath .. "../../nc-plugin/?.lua;" .. prefixPath .. "../../nc-plugin/?.lx;"
	path = path .. prefixPath .. "../../../nc-plugin/?.lua;" .. prefixPath .. "../../../nc-plugin/?.lx;"
	path = path .. prefixPath .. "../nc-plugin/preference/?.lua;" .. prefixPath .. "../nc-plugin/preference/?.lx;"
	path = path .. prefixPath .. "../../nc-plugin/preference/?.lua;" .. prefixPath .. "../../nc-plugin/preference/?.lx;"
	path = path .. prefixPath .. "../../../nc-plugin/preference/?.lua;" .. prefixPath .. "../../../nc-plugin/preference/?.lx;"
	-- load lua files from nc-backend
	path = path .. prefixPath .. "../nc-backend/?.lua;" .. prefixPath .. "../nc-backend/?.lx;"
	path = path .. prefixPath .. "../../nc-backend/?.lua;" .. prefixPath .. "../../nc-backend/?.lx;"
	path = path .. prefixPath .. "../../../nc-backend/?.lua;" .. prefixPath .. "../../../nc-backend/?.lx;"
	path = path .. prefixPath .. "../nc-backend/preference/?.lua;" .. prefixPath .. "../nc-backend/preference/?.lx;"
	path = path .. prefixPath .. "../../nc-backend/preference/?.lua;" .. prefixPath .. "../../nc-backend/preference/?.lx;"
	path = path .. prefixPath .. "../../../nc-backend/preference/?.lua;" .. prefixPath .. "../../../nc-backend/preference/?.lx;"
	-- path = path .. prefixPath .. "../nc-plugin/preference/form/?.lua;" .. prefixPath .. "../nc-plugin/preference/form/?.lx;"
	-- path = path .. prefixPath .. "../../nc-plugin/preference/form/?.lua;" .. prefixPath .. "../../nc-plugin/preference/form/?.lx;"
	-- path = path .. prefixPath .. "preference/form/?.lua;" .. prefixPath .. "preference/form/?.lx;"
	-- path = path .. prefixPath .. "../preference/form/?.lua;" .. prefixPath .. "../preference/form/?.lx;"
	path = path .. prefixPath .. "preference/?.lua;" .. prefixPath .. "preference/?.lx;"
	path = path .. prefixPath .. "../preference/?.lua;" .. prefixPath .. "../preference/?.lx;"
	path = path .. prefixPath .. "plugin/?.lua;" .. prefixPath .. "plugin/?.lx;"
	path = path .. prefixPath .. "../plugin/?.lua;" .. prefixPath .. "../plugin/?.lx;"

	if loc.from4d then
		path = path .. prefixPath .. "../nc-plugin/plugin/external/manager/?.lua;" .. prefixPath .. "../nc-plugin/plugin/external/manager/?.lx;"
		path = path .. prefixPath .. "../../nc-plugin/plugin/external/manager/?.lua;" .. prefixPath .. "../../nc-plugin/plugin/external/manager/?.lx;"
		path = path .. prefixPath .. "plugin/external/manager/?.lua;" .. prefixPath .. "plugin/external/manager/?.lx;"

		path = path .. prefixPath .. "../nc-plugin/plugin/external/manager/4d/?.lua;" .. prefixPath .. "../nc-plugin/plugin/external/manager/4d/?.lx;"
		path = path .. prefixPath .. "../../nc-plugin/plugin/external/manager/4d/?.lua;" .. prefixPath .. "../../nc-plugin/plugin/external/manager/4d/?.lx;"
		path = path .. prefixPath .. "plugin/external/manager/4d/?.lua;" .. prefixPath .. "plugin/external/manager/4d/?.lx;"
	end
	package.path = path -- ..package.path

	path = "" -- package.cpath: dll's
	if ffi.os == "Windows" then
		-- path = path..prefixPath.."../../../bin/bin_win_"..ffi.arch.."/?/core.dll;"
		path = path .. prefixPath .. "bin/?.dll;"
		path = path .. prefixPath .. "bin/bin_win_" .. ffi.arch .. "/?.dll;"
		path = path .. prefixPath .. "../bin/bin_win_" .. ffi.arch .. "/?.dll;"
		-- path = path..prefixPath.."../bin/bin_win_"..ffi.arch.."/?/core.dll;"
		path = path .. prefixPath .. "../../bin/bin_win_" .. ffi.arch .. "/?.dll;"
		-- path = path..prefixPath.."../x../bin/bin_win_"..ffi.arch.."/?/core.dll;"
		path = path .. prefixPath .. "../../../bin/bin_win_" .. ffi.arch .. "/?.dll;"
	elseif ffi.os == "Linux" then
		-- path = path..prefixPath.."../../../bin/bin_linux_"..ffi.arch.."/?/core.so;"
		path = path .. prefixPath .. "bin/?.so;"
		path = path .. prefixPath .. "bin/bin_linux_" .. ffi.arch .. "/?.so;"
		path = path .. prefixPath .. "../bin/bin_linux_" .. ffi.arch .. "/?.so;"
		-- path = path..prefixPath.."../bin/bin_linux_"..ffi.arch.."/?/core.so;"
		path = path .. prefixPath .. "../../bin/bin_linux_" .. ffi.arch .. "/?.so;"
		-- path = path..prefixPath.."../../bin/bin_linux_"..ffi.arch.."/?/core.so;"
		path = path .. prefixPath .. "../../../bin/bin_linux_" .. ffi.arch .. "/?.so;"
	else
		-- path = path..prefixPath.."../../../bin/bin_osx_"..ffi.arch.."/?/core.so;"
		-- path = path..prefixPath.."../../../bin/bin_osx_"..ffi.arch.."/?/core.dylib;"
		path = path .. prefixPath .. "bin/?.so;"
		path = path .. prefixPath .. "bin/bin_osx_" .. ffi.arch .. "/?.dylib;"
		path = path .. prefixPath .. "../bin/bin_osx_" .. ffi.arch .. "/?.dylib;"
		path = path .. prefixPath .. "../bin/bin_osx_" .. ffi.arch .. "/?.so;"
		path = path .. prefixPath .. "../bin/bin_osx_" .. ffi.arch .. "/?/core.so;"
		-- path = path..prefixPath.."../bin/bin_osx_"..ffi.arch.."/?/core.dylib;"
		path = path .. prefixPath .. "../../bin/bin_osx_" .. ffi.arch .. "/?.dylib;"
		path = path .. prefixPath .. "../../bin/bin_osx_" .. ffi.arch .. "/?.so;"
		path = path .. prefixPath .. "../../bin/bin_osx_" .. ffi.arch .. "/?/core.so;"
		-- path = path..prefixPath.."../../bin/bin_osx_"..ffi.arch.."/?/core.dylib;"
		path = path .. prefixPath .. "../../../bin/bin_osx_" .. ffi.arch .. "/?.dylib;"
		path = path .. prefixPath .. "../../../bin/bin_osx_" .. ffi.arch .. "/?.so;"
		path = path .. prefixPath .. "../../../bin/bin_osx_" .. ffi.arch .. "/?/core.so;"
	end
	package.cpath = path -- ..package.cpath
	setBinPath(prefixPath, showError)
end

printOld = print -- luacheck: no global
local ioWriteOld = io.write
local function setWindowsPrint()
	if ffi.os == "Windows" then -- false and
		local env = os.getenv("LUA_CPATH")
		if not env or not env:lower():find("vscode", 1, true) then -- not inside vscodeStudio
			local ok, utf = pcall(require, "utf")
			if ok == true then -- utf is not found inside 4d before setFrom4d()
				local function printRetLatin9(...)
					local arg = {...}
					local txt = ""
					for i, v in ipairs(arg) do
						if i == 1 then
							txt = tostring(v)
						else
							txt = txt .. "\t" .. tostring(v)
						end
					end
					printOld(utf.utf8ToCp850(txt)) -- luacheck: no global
				end
				print = printRetLatin9 -- luacheck: no global

				local function ioWriteRetLatin9(...)
					local arg = {...}
					local txt = ""
					for i, v in ipairs(arg) do
						if i == 1 then
							txt = tostring(v)
						else
							txt = txt .. "\t" .. tostring(v)
						end
					end
					ioWriteOld(utf.utf8ToCp850(txt))
				end
				io.write = ioWriteRetLatin9 -- luacheck: no global
			end
		end
	end
end

if not loc.startPath:find("Postgres", 1, true) then -- /Users/pasi/Library/Application Support/Postgres/var-10
	setFilePath("", false) -- first here, later from inside 4d with long 4d resoure path
	-- setFilePath() will call setBinPath()
	-- Postgres pllua will call start.setFilePath("...")
	setWindowsPrint()
end

local function setFrom4d(inTxtFrom4d)
	if inTxtFrom4d == nil then
		return
	end
	loc.from4d = true
	-- print to 4d log
	local function print4dLog(txt, ...)
		local arg = {...}
		txt = txt or ""
		if arg and (arg[1] ~= 1 or #arg > 1) then -- for some reason arg[1] is always 1?
			for _, val in ipairs(arg) do
				txt = txt .. " \t " .. tostring(val):gsub("\n", "\r")
			end
		end
		if not plg4d then
			local _
			_, plg4d = pcall(require, "plg4d")
		end
		--[[
		if txt == "" then
			txt = "empty print\n"..debug.traceback()
		end ]]
		if plg4d and plg4d.callMethodNoReturn and txt ~= "" then
			if type(txt) ~= "string" then
				txt = "print4dLog param type '" .. type(txt) .. "' is not text"
			end
			plg4d.callMethodNoReturn("_err LOG", txt:sub(1, 32000), "lx") -- last param is function name
		end
	end
	print = print4dLog -- luacheck: no global
	io.write = print4dLog -- luacheck: no global

	loc.runFrom4dFile, loc.pathFile, loc.path4d, loc.param = inTxtFrom4d:match("(.-)\n(.-)\n(.-)\n(.*)")
	if loc.pathFile == nil then
		loc.pathFile = "" -- must not contain "/" if is empty
	else
		loc.pathFile = loc.pathFile:gsub("manager/4d/", "")
		if loc.pathFile ~= "" and loc.pathFile:sub(-1) ~= "/" then
			loc.pathFile = loc.pathFile .. "/"
		end
	end
	if loc.path4d == nil then
		loc.path4d = ""
	else
		if loc.path4d ~= "" and loc.path4d:sub(-1) ~= "/" then
			loc.path4d = loc.path4d .. "/"
		end
	end

	do
		local os = ffi.os == "OSX" and "MacOS" or ffi.os
		loc.plgPath = loc.path4d .. "Plugins/MA-Plugin-x64.bundle/Contents/" .. os .. "/MA-Plugin-x64" .. (ffi.os == "Windows" and ".4dx" or "")
		local ok
		ok, loc.c4d = pcall(ffi.load, loc.plgPath)
		if ok == false or loc.c4d == nil then
			loc.plgPath = loc.path4d .. "../Plugins/MA-Plugin-x64.bundle/Contents/" .. os .. "/MA-Plugin-x64" .. (ffi.os == "Windows" and ".4dx" or "")
			ok, loc.c4d = pcall(ffi.load, loc.plgPath) -- compiled with engine
		end
		if ok == false or loc.c4d == nil then
			-- loc.c4d = nil
			-- print("*** start error, plgPath is not corret ***") -- can't use print because loc.c4d does not work
			oldAssert(false, string.format("*** start error, plgPath is not corret ***, loc.path4d: '%s', loc.plgPath: '%s', inTxtFrom4d: '%s', loc.c4d: '%s', loc.c4d.PA_SetStringVariable: '%s'", tostring(loc.path4d), tostring(loc.plgPath), tostring(inTxtFrom4d), tostring(loc.c4d), tostring(loc.c4d and loc.c4d.PA_SetStringVariable)))
			-- will cause plugin error and show error + strack trace in 4d log
		end
	end

	local pos = loc.pathFile:find("/nc-plugin/", 1, true)
	if pos then
		local path1 = loc.pathFile:sub(1, pos - 1) .. "/nc-server/"
		-- path1 = path1 .. "lib/?.lua;" .. path1 .. "lib/?.lx;"
		setFilePath(path1) -- needed for require "lfs_load" to work
	else
		pos = loc.pathFile:find("/nc-server-dist/", 1, true)
		if pos then
			local path1 = loc.pathFile:sub(1, pos - 1) .. "/nc-server-dist/"
			setFilePath(path1) -- needed for require "lfs_load" to work
		end
	end
	-- local lfs = require "lfs_load" -- must be after setting path
	--[[ if not loc.from4d and lfs.attributes(loc.pathGit .. "nc-server") then -- lfs.attributes cant't handle last "/"
		loc.pathFile = loc.pathGit .. "nc-server/"
		setFilePath(loc.pathFile) -- use git path if it git path is found
	end ]]
	loc.pathBin = loc.path4d .. "Resources/bin/bin_" .. ffi.os:lower():gsub("windows", "win") .. "_" .. ffi.arch .. "/"
	--[[
	print("loc.runFrom4dFile: "..loc.runFrom4dFile)
	print("loc.pathFile: "..loc.pathFile)
	print("loc.path4d: "..loc.path4d)
	print("loc.param: "..loc.param)
	--]]
end

-- local oldError = error
local ioWrite = io.write
local color
error = function(message) -- luacheck: no global
	if color == nil then
		color = require "ansicolors"
	end
	ioWrite("\n")
	print(color("%{bright red}error: '" .. tostring(message) .. "'\n  [" .. debug.traceback() .. "]\n"))
end

assert = function(value, message) -- luacheck: no global
	if not value then -- nil or false == error
		error(message)
	end
	return value
end

local function getLocal()
	return loc
end

local json
print = function(txt1, ...) -- luacheck: no global
	-- override print with jit compiled io.write()
	local function write(txt)
		if txt == nil then
			return
		elseif type(txt) == "string" then
			ioWrite(txt)
		elseif type(txt) == "number" then
			-- util = util or require "util"
			-- ioWrite(string.format("wrong print type '%s'", type(txt))..util.callPath().."\n")
			ioWrite(tostring(txt))
		elseif type(txt) == "table" then
			json = json or require "json"
			local txt3, err = json.toJson(txt, "clean")
			ioWrite(txt3 or err)
		elseif type(txt) == "boolean" then
			ioWrite(tostring(txt))
		elseif type(txt) == "cdata" then
			ioWrite(tostring(txt))
		elseif type(txt) == "userdata" then
			ioWrite(tostring(txt))
		else
			ioWrite(tostring(txt))
			ioWrite(string.format(" -- unknown print type '%s'", type(txt)) .. "\n")
		end
	end
	write(txt1)
	if ... then
		local arg = {...}
		for _, txt2 in ipairs(arg) do
			ioWrite("\t")
			write(txt2) -- txt2 can be any type, recursive call
		end
	end
	ioWrite("\n")
	-- io.flush()
end

if jit and jit.opt and jit.opt.start then
	local ok = pcall(jit.opt.start, "+fma") -- see: https://github.com/LuaJIT/LuaJIT/issues/918#issuecomment-1341344043
	if not ok then
		print("\n------------------------------------------------------------------------\n *** jit.opt.start('+fma') failed, please update your binary folder ***\n------------------------------------------------------------------------")
	end
end

return {startPath = loc.startPath, userName = loc.userName, getLocal = getLocal, setFilePath = setFilePath, setFrom4d = setFrom4d}
