-- lib/table-code.lua
-- new Vue2 scripts
-- @module tableCode
local tableCode = {}

local dschema = require "dschema"
local util = require "util"
local dqry = require "dqry"
local dload = require "dload"
local dprf = require "dprf"
local l = require"lang".l
local peg = require "peg"
local recData = require"recdata".get
local recDataSet = require"recdata".set
local tableCode4d = require "plugin/external/manager/4d/table-code-4d"
local qry

local tableCodeCache

local function loadLibs()
	qry = require "qry"
end

function tableCode.setLinkedRecord(rec, queryName, queryParameter, options)
	loadLibs()
	rec.link_grid = nil
	local grid = {{name = "link_grid", query = queryName, column = peg.replace(queryName, ".json", "-column.json")}}
	local call = {name = queryName, query = {grid = grid}, parameter = queryParameter}
	local ret = qry.query(call)
	if ret.error then
		return ret.error
	elseif ret.grid == nil or ret.grid.link_grid == nil or ret.grid.link_grid.data == nil then
		return l("linked table record was not found, query '%s'", queryName)
	elseif #ret.grid.link_grid.data == 1 then
		local linkedRec = ret.grid.link_grid.data[1]
		local value = recData(linkedRec, options.data_field)
		recDataSet(rec, options.link_field, value)
		recDataSet(rec, options.tag, linkedRec)
	else
		rec.link_grid = {grid = ret.grid.link_grid, link_field = options.link_field, data_field = options.data_field}
	end
	--[[ TODO: caching to calc server
	tagName = tagName or "_link_" .. tableName
	saveRec[tagName] = ret.data[1]
	if options and options.rec_field and options.link_field then
		if saveRec[tagName][options.link_field] and saveRec[tagName][options.link_field] ~= saveRec[options.rec_field] then
			saveRec[options.rec_field] = saveRec[tagName][options.link_field]
		end
	end ]]
end

local function getLinkedFiedArray(prf, prfName, tablePrefix)
	if prf.linked_fied_array == nil then
		util.printError("tag linked_fied_array was not found from preference '%s'", prfName)
		prf.linked_fied_array = {[tablePrefix] = {}}
	elseif prf.linked_fied_array[tablePrefix] == nil then
		util.printError("tag linked_fied_array[%s] was not found from preference '%s'", tostring(tablePrefix), prfName)
		prf.linked_fied_array[tablePrefix] = {}
	end
	return prf.linked_fied_array[tablePrefix]
end

local function getLinkedQueryFiledArray(prf, tablePrefix)
	if prf.query_field_array == nil or prf.query_field_array[tablePrefix] == nil then
		return nil
	end
	return prf.query_field_array[tablePrefix]
end

local function getLinkedRecordType(prf, tablePrefix)
	if prf.linked_record_type == nil or prf.linked_record_type[tablePrefix] == nil then
		return nil
	end
	return prf.linked_record_type[tablePrefix]
end

local linkedFiedArray = {}
local linkedQueryFiledArray = {}
local linkedRecordType = {}
local currentSchema, currentCode -- , currentTable
local linkedFieldMetatable = {
	__index = function(item, tablePrefix)
		local primaryKeyField = dschema.tablePrefixToPrimaryKeyField(tablePrefix, currentSchema)
		if primaryKeyField == nil then
			util.printError("table code table prefix '%s' was not found", tablePrefix)
		end
		local recordField = peg.parseAfter(primaryKeyField, tablePrefix .. ".")
		if item[recordField] == nil then
			util.printError("table code field '%s' is missing in record", primaryKeyField)
			item[tablePrefix] = {json_data = {}}
			return
		end
		if linkedFiedArray[tablePrefix] == nil then
			--[[ local tableName = dschema.tableName(primaryKeyField)
			local schema = ""
			local recType = nil
			linkedFiedArray[tablePrefix] = dschema.localFieldArray(tableName, schema, recType) -- todo: read code ]]
			local prf, prfName = currentCode.preference(tablePrefix)
			linkedFiedArray[tablePrefix] = getLinkedFiedArray(prf, prfName, tablePrefix)
			linkedQueryFiledArray[tablePrefix] = getLinkedQueryFiledArray(prf, tablePrefix)
			linkedRecordType[tablePrefix] = getLinkedRecordType(prf, tablePrefix)
		end
		local value = item[recordField]
		dqry.query("", primaryKeyField, "=", value, linkedRecordType[tablePrefix], "table code related find") -- needs record_type as 5. param
		if linkedQueryFiledArray[tablePrefix] then
			for _, field in ipairs(linkedQueryFiledArray[tablePrefix]) do
				dqry.query("or", field, "=", value, linkedRecordType[tablePrefix], "table code related find")
			end
		end
		local sel = dload.selectionToRecordArray(linkedFiedArray[tablePrefix])
		if sel and #sel > 1 then
			util.printError("table code field '%s' value '%s' query returned more than one record", primaryKeyField, tostring(value))
			item[tablePrefix] = sel[1] -- todo: check the right one
		elseif sel and sel[1] then
			item[tablePrefix] = sel[1]
		else
			util.printError("table code field '%s' value '%s' was not found", primaryKeyField, tostring(value))
			item[tablePrefix] = {json_data = {}}
		end
		return item[tablePrefix]
	end
}

local function luaTableCode(codeRec, param)
	--[[
	if param.database == nil then
		param.database = "4d" -- FIX
	end
	--]]
	local err
	currentSchema = param.schema
	-- currentTable = param.table
	if param.table and param.run_script then -- for testing
		local runTableCodeRec = util.arrayRecord(param.table, param.run_script, "table", 1)
		if runTableCodeRec and runTableCodeRec.script_field then
			param.field_name = runTableCodeRec.script_field
			param.run_save_script = true
		end
	end
	if param.table == nil then
		err = l("parameter 'table' is missing")
	elseif param.modify_rec == nil then
		err = l("parameter 'modify_rec' is missing")
	elseif param.field_name == nil and not param.run_save_script then
		err = l("parameter 'field_name' is missing")
	end
	local newData
	if err == nil then
		local code = codeRec.code
		--[[ if false then
			err = addMissingField(rec, code, param)
		end
		if err == nil then]]
		local function runCode(fieldNamePrefix)
			local prefix = dschema.tablePrefix(param.table)
			local fieldNameLong = peg.parseAfter(fieldNamePrefix, prefix .. ".")
			local fieldName
			if fieldNameLong:sub(1, 10) == "json_data." then
				fieldName = fieldNameLong:sub(11)
				code = code.json_data
			else
				fieldName = fieldNameLong
			end
			currentCode = code
			if currentCode[fieldName] == nil then
				newData = {[prefix] = param.modify_rec}
				if param.develop then
					util.print("table '%s' field '%s' has no code in file '%s'", param.table, fieldNameLong, codeRec.path)
				end
			else
				-- local prev = util.clone(param.modify_rec)
				setmetatable(param.modify_rec, linkedFieldMetatable)
				local ok, errMessage = pcall(currentCode[fieldName], param.modify_rec, param)
				if ok == false then
					err = l("table '%s' field '%s' code stopped with error '%s'\n  parameter: '%s'", param.table, fieldNameLong, errMessage, param)
				elseif errMessage then
					err = l("table '%s' field '%s' code returned error '%s'\n  parameter: '%s'", param.table, fieldNameLong, errMessage, param)
				else -- if not util.tableEqual(param.modify_rec, prev) then
					newData = {[prefix] = param.modify_rec}
					--[[ newData = newData or {}
					newData[#newData + 1] = param.modify_rec ]]
				end
			end
		end

		if err == nil then
			if param.run_save_script and code.save then
				for _, saveFunc in ipairs(code.save) do
					saveFunc(param)
				end
			elseif type(param.field_name) == "string" then
				runCode(param.field_name)
			elseif type(param.field_name) == "table" then
				for _, fieldNamePrefix in ipairs(param.field_name) do
					runCode(fieldNamePrefix)
				end
			end
		end
	end
	return {error = err, rec = newData} -- , new_data = newData, link_grid = grid, grid_rec = param.grid_rec
end

local function getTableCode(tableName)
	if tableCodeCache == nil then
		tableCodeCache = {}
		dprf.registerCache("tableCodeCache", tableCodeCache)
	end
	local codeRec = tableCodeCache[tableName]
	if codeRec == false then -- was loaded before, no codeRec
		return nil
	end
	if codeRec == nil or util.tableIsEmpty(codeRec) then
		local ok, code
		local path = dschema.tableCodePath(tableName)
		if path then
			ok, code = pcall(require, "preference/" .. path)
		end
		if ok == true and code then
			util.print("  table '%s' code file '%s' loaded", tableName, path)
			codeRec = {path = path, code = code}
			tableCodeCache[tableName] = codeRec
		elseif path then
			util.printError("table '%s' code file '%s' load returns an error '%s'", tableName, path, code)
			codeRec = false
		else
			util.printRed("table '%s' code file '%s' does not exits", tableName, path)
			codeRec = false
			tableCodeCache[tableName] = false -- do not try to load again
		end
	end
	return codeRec
end

local run4DCode
local function runTableCode(param)
	local result4d
	if param.schema == "4d" and param.develop and not util.isLinux() then
		if run4DCode == nil then
			run4DCode = dprf.prf("table/table-code.json").run_4d_code
		end
		if run4DCode == true then
			result4d = tableCode4d.runFieldCode(param)
		end
	end
	local codeRec = getTableCode(param.table)
	if codeRec then
		local result = luaTableCode(codeRec, param)
		if run4DCode then
			if not (result4d and result4d.code_rec and type(result4d.code_rec[param.table_prefix]) == "table") then
				util.printError("table '%s' 4d code result is not a table", param.table)
			elseif not (result and result.rec and type(result.rec[param.table_prefix]) == "table") then
				util.printError("table '%s' local code result is not a table", param.table)
			else
				local rec4d = result4d.code_rec[param.table_prefix]
				local recLocal = result.rec[param.table_prefix]
				local err = {}
				for field, val in pairs(rec4d) do
					if field ~= "json_data" and recLocal[field] ~= val then
						err[#err + 1] = util.printRed("table '%s' code results are different, field '%s.%s' 4D value '%s', local value '%s'", param.table, param.table_prefix, field, tostring(val), tostring(recLocal[field]))
					end
				end
				if #err > 0 then
					result.warning = err
				end
			end
		end
		return result
	end
end
tableCode.runTableCode = runTableCode

function tableCode.runSaveTableCode(param)
	param.run_save_script = true
	return runTableCode(param)
end

function tableCode.recalculateMainRec(param, rec, grid, calledFrom)
	if not rec._var then
		rec._var = {}
	end
	if calledFrom == "onLoad" then -- called from input
		for _, gridArea in pairs(grid) do
			local scriptParam = {rec = gridArea.data, mrec = rec, linked_table = gridArea.table, option = "recalculate"}
			-- if scriptMain and scriptMain.linkedChange then
			--	scriptMain.linkedChange(scriptParam)
			-- end
			runTableCode(scriptParam)
		end
	else -- calledFrom == "onSave",  called from save
		for tbl, data in pairs(grid) do
			local scriptParam = {rec = data, mrec = rec, linked_table = tbl, option = "recalculate"}
			runTableCode(scriptParam)
			-- if scriptMain and scriptMain.linkedChange then
			--	scriptMain.linkedChange(scriptParam)
			-- end
		end
	end
	local scriptParam = {rec = param.rec, table = param.table, run_save_script = true}
	runTableCode(scriptParam)
end

return tableCode

--[=[

local function recalculateMainRec(param, rec, grid, calledFrom)
	if not rec._var then
		rec._var = {}
	end
	if calledFrom == "onLoad" then -- called from input
		for _, gridArea in pairs(grid) do
		end
	else -- calledFrom == "onSave",  called from save
		for tbl, data in pairs(grid) do
		end
	end
end

local function recordLinkedField(tableName, field, scriptPref)
	-- red pref and cache unique linked fields by linking field and by tableName == all unique linked fields
end

local function recValue(param, rec) -- option == "all"
	if param.rec._var[rec.from] ~= nil then
		return param.rec._var[rec.from]
	elseif param.rec[rec.from] ~= nil then
		return param.rec[rec.from]
	end
end

local function addLinkedField(param, scriptPref, option) -- option == "all"
	local err = {}
	local linkedFldArr, varTbl, setTbl = recordLinkedField(param.table, param.field_name, scriptPref)
	if linkedFldArr and #linkedFldArr > 0 then
		local fld = param.field_name
		local linkedRec, info = dload.linkedRecord(fld, param.rec[param.field_name], linkedFldArr, conn)
		if linkedRec then
			for key, val in pairs(linkedRec) do
				if varTbl and varTbl[key] then
					param.rec._var[varTbl[key]] = val
				else
					param.rec._var[key] = val
				end
			end
			-- param.rec._var = util.tableCombine(param.rec._var, linkedRec, "no-error") -- reportError == false, combines fields of linkedRec to param.rec
		end
		if setTbl then
			for _, rec in ipairs(setTbl) do
				local value = recValue(param, rec)
				if rec.variable ~= nil then
					if value ~= nil then
						param.rec._var[rec.variable] = value
					else
						err[#err + 1] = l("set variable '%s' value does not exist, preference '%s'", rec.variable, "tableCode/" .. param.table .. ".json")
						util.printError(err[#err])
					end
				end
				if rec.to ~= nil then
					if param.rec[rec.to] == nil then
						err[#err + 1] = l("set field '%s' does not exist, preference '%s'", rec.to, "tableCode/" .. param.table .. ".json")
						util.printError(err[#err])
					elseif value ~= nil then
						param.rec[rec.to] = value
					else
						err[#err + 1] = l("set field '%s' value does not exist, preference '%s'", rec.to, "tableCode/" .. param.table .. ".json")
						util.printError(err[#err])
					end
				end
			end
			-- param.rec._var = util.tableCombine(param.rec._var, linkedRec, "no-error") -- reportError == false, combines fields of linkedRec to param.rec
		end
	end
	if #err < 1 then
		err = nil
	else
		err = table.concat(err, "\n")
	end
	return setTbl, err
end

local function addMissingField(rec, code, param)
	if code.script_field == nil then
		util.printWarning(l("table '%s' tableCode has no script_field defined", param.table))
		return
	end
	local localTable = dconv.prefixToLocalPrefix(param.table) -- dconv.prefixToPrefix(param.table)
	local queryName = code.script_field[localTable]
	if queryName == nil or queryName == " " then
		return
	end
	local newFieldTbl
	local recordIdField = localTable .. "_record_id"
	if rec[recordIdField] == nil or rec[recordIdField] == "" then
		local fieldArr = util.prf("query/" .. queryName)
		if fieldArr and fieldArr.field then
			fieldArr = fieldArr.field
			-- fieldArr = dconv.externalToLocalRec(fieldArr, param.table, param.field_name)
			newFieldTbl = {}
			for _, fld in ipairs(fieldArr) do
				local newValue = dschema.fieldDefaultValue(fld)
				local newFld = dschema.localNameWithRecType(fld)
				newFieldTbl[newFld] = newValue
			end
			-- newFieldTbl = dconv.externalToLocalRec(newFieldTbl, rec.param.table)
		end
	else
		local tagName = "_link_" .. localTable
		-- dload.setLinkedRecord
		local err = dload.setLinkedRecord(rec, queryName, {record_id = rec[recordIdField]}, {tag_name = tagName})
		if err then
			return err
		end
		newFieldTbl = rec[tagName]
		rec[tagName] = nil
		-- newFieldTbl = dconv.externalToLocalRec(rec["_link_"..param.table], rec.param.table)
		-- rec["_link_"..param.table..] = nil
	end
	if newFieldTbl then
		for fld, val in pairs(newFieldTbl) do
			if rec[fld] == nil then
				rec[fld] = val
			end
		end
	end
end

function tableCode.scriptFunction(table)
	local code = code(table)
	return code and code or nil
end
]=]
