-- unicodeIcu.lua
module(..., package.seeall)

local ffi = require "mffi"
local util = require "util"
local icu = nil -- loaded later
local ustring = nil -- loaded later
local collator -- loaded later

local function directory_exists(path)
	local lfs = require "lfs_load"
	if lfs.attributes(path) then
		return true
	end
  do return false end

  local f  = io.popen("cd " .. path)
  local ff = f:read("*all")
  if (ff:find("ItemNotFoundException", 1, true)) then
    return false
  else
    return true
  end
end

-- local icu_utf8 = require "icu.utf8"
-- local U = require "icu.ustring"
-- local char = string.char

-- typedef unsigned short PA_Unichar;
-- in OSX 64bit ffi.sizeof("PA_Unichar") == 2
-- in OSX 64bit ffi.sizeof("uint8_t") == 1
-- local bytesInUnichar = ffi.sizeof("PA_Unichar") / ffi.sizeof("uint8_t")
-- print("bytesInUnichar: "..bytesInUnichar)

--[[
require "lualibs-lua"
require "lualibs-peg"
require "lualibs-unicode"
]]

if not icu then
  if ffi.os == "Windows" then
			-- print("pathdll: "..pathdll)
      -- dll's must be loaded in windows
			ffi.loadMsvcr() -- "120"
			ffi.loadMsvcp() -- "120"

      util.loadDll("icudt52.dll")
      util.loadDll("icuuc52.dll")
      util.loadDll("icuin52.dll")
      util.loadDll("icuio52.dll")
    -- are these dll's needed by icu4lua?
    -- util.loadDll("icule52.dll")
    -- util.loadDll("icutu52.dll")
    -- util.loadDll("iculx52.dll")
  end
	icu = require "icu"
	ustring = require "icu.ustring"
	collator = require "icu.collator"
end
local uencode = ustring.encode
local udecode = ustring.decode
local ulower = ustring.lower
local ulessthan = ustring.lessthan

function fromUtf16(uchar, bytelen)
	local utf16 = ffi.string(uchar, bytelen)
	return icu.convert(utf16, "UTF-16LE", "UTF-8")
end

function convert(str, from, to)
	return icu.convert(str, from, to)
end

function encode(str, charset)
	return uencode(str, charset)
end

function decode(a, charset)
	return udecode(a, charset)
end

function lower(str)
	return uencode(ulower(udecode(str)))
end

function uLower(ustr)
	return ulower(ustr)
end

function lessThan(a, b)
	return ulessthan(udecode(a), udecode(b))
end

function uLessThan(a, b)
	return ulessthan(a, b)
end

function collatorStrength(coll, new_value)
	if new_value then
		if new_value == "primary" then
			new_value = collator.PRIMARY
		elseif new_value == "secondary" then
			new_value = collator.SECONDARY
		elseif new_value == "tertiary" then
			new_value = collator.TERTIARY
		elseif new_value == "quaternary" then
			new_value = collator.QUATERNARY
		elseif new_value == "identical" then
			new_value = collator.IDENTICAL
		elseif new_value == "default" then
			new_value = collator.DEFAULT_STRENGTH -- same as "tertiary"
		else
			-- error
		end
		return collator.strength(coll, new_value)
	end
	return collator.strength(coll)
end

function collatorOpen(str, strength)
	return collator.open(str)
end

function collatorLessThan(coll, a, b)
	return collator.lessthan(coll, udecode(a), udecode(b))
end

function uCollatorLessThan(coll, a, b)
	return collator.lessthan(coll, a, b)
	--[[if collator.lessthan(coll, a, b) then
		return true
	-- elseif ulessthan(a, b) then
		-- return true
	end
	return false]]
end
