--- vips_load.lua
-- https://github.com/jcupitt/lua-vips/issues/12#issuecomment-309730843
-- @module graphics
local util = require "util"
local ffi = require "mffi"

local vips = {}

if util.isWin() then
	local cairo = require "draw/cairo_load_win"
	vips.glib, vips.gobject = cairo.glib, cairo.gobject
	-- not loaded by cairo_load_win
	-- util.loadDll("clang/libunwind.dll")
	util.loadDll("graphics/vips/libcrypto-3-x64.dll")
	util.loadDll("graphics/vips/libarchive-13.dll")
	util.loadDll("graphics/vips/libcfitsio-10.dll")

	util.loadDll("graphics/vips/libzstd.dll")
	util.loadDll("graphics/vips/libb2-1.dll")
	util.loadDll("graphics/vips/libdatrie-1.dll")
	util.loadDll("graphics/vips/libdeflate.dll")
	util.loadDll("graphics/vips/libexif-12.dll")
	util.loadDll("graphics/vips/libfftw3-3.dll")
	util.loadDll("graphics/vips/libfribidi-0.dll")
	util.loadDll("graphics/vips/libgdk_pixbuf-2.0-0.dll")
	util.loadDll("graphics/vips/libgraphite2.dll")
	util.loadDll("graphics/vips/libhwy.dll")
	util.loadDll("graphics/vips/libidn2-0.dll")
	util.loadDll("graphics/vips/libIex-3_2.dll")
	util.loadDll("graphics/vips/libIlmThread-3_2.dll")
	util.loadDll("graphics/vips/libImath-3_1.dll")
	util.loadDll("graphics/vips/libjbig-0.dll")
	util.loadDll("graphics/vips/libjpeg-8.dll")
	util.loadDll("graphics/vips/liblcms2-2.dll")
	util.loadDll("graphics/vips/libLerc.dll")
	util.loadDll("graphics/vips/liblz4.dll")
	util.loadDll("graphics/vips/libnghttp2-14.dll")
	util.loadDll("graphics/vips/libnghttp3-9.dll")
	util.loadDll("graphics/vips/libOpenEXR-3_2.dll")
	util.loadDll("graphics/vips/libOpenEXRCore-3_2.dll")
	util.loadDll("graphics/vips/libopenjp2-7.dll")
	util.loadDll("graphics/vips/libpango-1.0-0.dll")
	util.loadDll("graphics/vips/libpangocairo-1.0-0.dll")
	util.loadDll("graphics/vips/libpangoft2-1.0-0.dll")
	util.loadDll("graphics/vips/libpangowin32-1.0-0.dll")
	util.loadDll("graphics/vips/libpsl-5.dll")
	util.loadDll("graphics/vips/librsvg-2-2.dll")
	util.loadDll("graphics/vips/libsharpyuv-0.dll")
	util.loadDll("graphics/vips/libssh2-1.dll")
	util.loadDll("graphics/vips/libssl-3-x64.dll")
	util.loadDll("graphics/vips/libsz-2.dll")
	util.loadDll("graphics/vips/libthai-0.dll")
	util.loadDll("graphics/vips/libtiff-6.dll")
	util.loadDll("graphics/vips/libwebp-7.dll")
	util.loadDll("graphics/vips/libwebpdemux-2.dll")
	util.loadDll("graphics/vips/libwebpmux-3.dll")
	util.loadDll("graphics/vips/imagequant.dll")
	util.loadDll("graphics/vips/libcurl-4.dll")
	util.loadDll("graphics/vips/libmatio-13.dll")
	util.loadDll("graphics/vips/libhdf5-310.dll")
	-- load vips
	vips.vips = util.loadDll("graphics/vips/libvips-42.dll") -- x64
elseif util.isMac() then
	-- vips.vips = ffi.load("/opt/homebrew/Cellar/vips/8.15.3_2/lib/libvips.42.dylib")
	vips.vips = util.loadDll("graphics/vips/libvips.42.dylib")
	vips.gobject = vips.vips
	vips.glib = vips.vips
else
	-- sudo apt-get install libvips
	-- local lib = util.loadDll("graphics/vips/libwebp.so.7")
	-- lib = util.loadDll("graphics/vips/libwebpmux.so.3")
	-- vips.vips = util.loadDll("graphics/vips/libvips.so.42")
	local ok, lib = pcall(ffi.load, "libvips.so.42")
	if not ok then
		util.printRed("loading libvips failed: install it using 'sudo apt-get install libvips42'")
		vips.vips = nil
	else
		vips.vips = lib
	end
	vips.gobject = vips.vips
	vips.glib = vips.vips
end

return vips
