--- lib/wepoll.lua
-- wepoll - epoll for windows
-- https://github.com/piscisaureus/wepoll

local wepoll
local ffi = require "ffi"
local util = require "util"

ffi.cdef[[

static const int EPOLLIN      = (1U <<  0);
static const int EPOLLPRI     = (1U <<  1);
static const int EPOLLOUT     = (1U <<  2);
static const int EPOLLERR     = (1U <<  3);
static const int EPOLLHUP     = (1U <<  4);
static const int EPOLLRDNORM  = (1U <<  6);
static const int EPOLLRDBAND  = (1U <<  7);
static const int EPOLLWRNORM  = (1U <<  8);
static const int EPOLLWRBAND  = (1U <<  9);
static const int EPOLLMSG     = (1U << 10);
static const int EPOLLRDHUP   = (1U << 13);
static const int EPOLLONESHOT = (1U << 31);

static const int EPOLL_CTL_ADD = 1;
static const int EPOLL_CTL_MOD = 2;
static const int EPOLL_CTL_DEL = 3;

/* enum EPOLL_EVENTS { // already defined as enum EPOLL_EVENTS {
  EPOLLIN      = (int) (1U <<  0),
  EPOLLPRI     = (int) (1U <<  1),
  EPOLLOUT     = (int) (1U <<  2),
  EPOLLERR     = (int) (1U <<  3),
  EPOLLHUP     = (int) (1U <<  4),
  EPOLLRDNORM  = (int) (1U <<  6),
  EPOLLRDBAND  = (int) (1U <<  7),
  EPOLLWRNORM  = (int) (1U <<  8),
  EPOLLWRBAND  = (int) (1U <<  9),
  EPOLLMSG     = (int) (1U << 10), / * Never reported. * /
  EPOLLRDHUP   = (int) (1U << 13),
  EPOLLONESHOT = (int) (1U << 31)
}; */

typedef union epoll_data {
  void* ptr;
  int fd;
  uint32_t u32;
  uint64_t u64;
  SOCKET sock;        /* Windows specific */
  HANDLE hnd;         /* Windows specific */
} epoll_data_t;

struct epoll_event {
  uint32_t events;    /* Epoll events and flags */
  epoll_data_t data;  /* User data variable */
};

HANDLE epoll_create(int size);
HANDLE epoll_create1(int flags);
int epoll_close(HANDLE ephnd);
int epoll_ctl(HANDLE ephnd,
              int op,
              SOCKET sock,
              struct epoll_event* event);
int epoll_wait(HANDLE ephnd,
               struct epoll_event* events,
               int maxevents,
               int timeout);

]]

wepoll = util.loadDll("wepoll")
return wepoll
