--- xml_write.lua
-- generate xml with genx syntax
-- https://luapower.com/genx
-- https://github.com/luapower/genx/blob/master/csrc/genx/genx.c
local doc = {}
doc.__index = doc

local util = require "util"
local fn = require "fn"
local docCount = 0
-- local namespace = 'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema"'

function doc.new() -- (tbl)
	docCount = docCount + 1 -- global count of alive
	local self = {} -- tbl = tbl or {}
	-- tbl.name = tbl.name or "doc-"..docCount
	return setmetatable(self, doc)
end

function doc.count()
	return docCount
end

function doc:ns(name, namespace)
	return {name, namespace}
end

function doc:add_ns(ns)
	if self.out then
		self.out[#self.out + 1] = " xmlns:" .. ns[2] .. '="' .. ns[1] .. '"'
	end
end

function doc:start_doc(func, option)
	if func ~= nil and type(func) ~= "function" then
		util.printError("first parameter must be function or nil")
	else
		self.callback = func
		self.option = option -- allow_empty_tag = allow <tag/> instead of <tag></tag>
		self.out = {}
		self.tag = {}
		self.tagStartClosed = {}
		self.startCount = 0
		self.endCount = 0
		self.depth = 0
	end
end

local function closeStartTag(self, depth, endTag)
	if not self.tagStartClosed[depth] then
		if self.attr then
			fn.iter(self.attr):each(function(rec)
				self.out[#self.out + 1] = " " .. rec[1] .. '="' .. rec[2] .. '"'
			end)
			self.attr = nil
		end
		self.out[#self.out + 1] = endTag or ">"
		self.tagStartClosed[depth] = true
	end
end

function doc:start_element(tag)
	if self.out then
		if type(tag) ~= "string" then
			util.printError("xml tag type '%s' is not string", type(tag))
		else
			self.startCount = self.startCount + 1
			self.depth = self.depth + 1
			if self.depth > 1 then
				closeStartTag(self, self.depth - 1)
			end
			self.tag[self.depth] = tag
			self.out[#self.out + 1] = "<"
			self.out[#self.out + 1] = tag
			-- if self.depth == 1 then
			-- self.out[#self.out + 1] = " "..namespace
			-- end
		end
	end
end

function doc:end_element()
	if self.out then
		self.endCount = self.endCount + 1
		if not self.text_value and self.option and self.option.allow_empty_tag and self.endCount == self.endCount and not self.tagStartClosed[self.depth] then
			closeStartTag(self, self.depth, "/>") -- just end tag with no sub tags or value
		else
			closeStartTag(self, self.depth)
			if self.text_value then
				self.out[#self.out + 1] = self.text_value -- table.concat(self.text_value)
				self.out[#self.out + 1] = "</"
				self.out[#self.out + 1] = self.tag[self.depth]
				self.out[#self.out + 1] = ">"
				self.text_value = nil
			else
				self.out[#self.out + 1] = "</"
				self.out[#self.out + 1] = self.tag[self.depth]
				self.out[#self.out + 1] = ">"
			end
			-- self.tag[self.depth] = nil
		end
		self.tagStartClosed[self.depth] = false -- re-use
		self.depth = self.depth - 1
	end
end

function doc:add_attr(key, value)
	if self.out then
		if type(key) ~= "string" then
			util.printError("xml attribute key type '%s' is not string", type(key))
		elseif type(value) ~= "string" then
			util.printError("xml attribute value type '%s' is not string", type(key))
		else
			if not self.attr then
				self.attr = {}
			end
			self.attr[#self.attr + 1] = {key, value}
		end
	end
end

function doc:text(value)
	if self.out then
		if type(value) ~= "string" then
			util.printError("xml data type '%s' is not string", type(value))
		else
			-- if value ~= "" then
			self.text_value = value -- or table?, could add to text
			-- end
		end
	end
end

function doc:add_element(tag, data)
	-- not in genx, added by manage
	doc.start_element(self, tag)
	doc.text(self, data)
	doc.end_element(self)
end

function doc:end_doc()
	if self.out then
		-- call self.func to generate whole xml
		if self.callback then
			fn.iter(self.out):each(self.callback)
			--[[
			fn.iter(self.out):each(function(rec)
				if type(rec) == "string" then
					self.callback(rec)
				else
					util.printError("xml data type '%s' is not string or number", type(rec))
				end
			end)
			--]]
		end
		return self.out -- table.concat(self.out)
	end
end

function doc:free()
	docCount = docCount - 1
	self.callback = nil
	self.out = nil
	self.tag = nil
	self.tagStartClosed = nil
	self.depth = nil
end

return doc

--[[
* json_to_xml.lua
   local doc = genx.new()
   86:   doc:start_doc(function(s, sz)
  267:         doc:start_element(tag)
  277:             doc:add_attr(key, value)
  298:             doc:text(tostring(value))
	159: 				  doc:end_element()
  525:     doc:end_doc()
  527:   doc:free()


int genxScrubText(genxWriter w, constUtf8 in, utf8 out)
{
  int problems = 0;
  constUtf8 last = in;

  while (*in)
  {
    int c = genxNextUnicodeChar(&in);
    if (c == -1)
    {
      problems++;
      last = in;
      continue;
    }

    if (!isXMLChar(w, c))
    {
      problems++;
      last = in;
      continue;
    }

    while (last < in)
      *out++ = *last++;
  }
  *out = 0;
  return problems;
}

]]
