--- xmlsec_ffi.lua

local ffi = require "mffi"
-- at then end: require "xmlsec_xslt" -- needs xml definitions
require "xmlua" -- definitions in here

ffi.cdef[[
typedef void (*xmlGenericErrorFunc) (void *ctx,
				 const char *msg,
				 ...); // LIBXML_ATTR_FORMAT(2,3);
]]

ffi.cdef[[
int xmlLineNumbersDefault(int val);
xmlDocPtr xmlReadFile(const char *URL, const char *encoding, int options);
// xmlDocPtr xmlReadMemory(const char *buffer, int size, const char *URL, const char *encoding, int options);
void xmlMemoryDump(void);
]]

ffi.cdef[[
// xmlsec.h
typedef enum {
    xmlSecCheckVersionExactMatch = 0,
    xmlSecCheckVersionABICompatible
} xmlSecCheckVersionMode;

// static const int XMLSEC_KEYINFO_FLAGS_DONT_STOP_ON_KEY_FOUND = 0x00000001;
static const int XMLSEC_KEYINFO_FLAGS_X509DATA_DONT_VERIFY_CERTS = 0x00000200;

//version.h
static const int XMLSEC_VERSION_MAJOR	= 1;
static const int XMLSEC_VERSION_MINOR		= 2;
static const int XMLSEC_VERSION_SUBMINOR	= 28;

int xmlSecInit              (void);
int xmlSecShutdown          (void);
int xmlSecCheckVersion      (void);
int xmlSecCheckVersionExt   (int major,
															 int minor,
															 int subminor,
															 xmlSecCheckVersionMode mode);

// app.h
// symbols.h
int xmlSecOpenSSLAppInit      (const char* config);
int xmlSecOpenSSLAppShutdown        (void);

int xmlSecOpenSSLInit                (void);
int xmlSecOpenSSLShutdown            (void);

int xmlSecGnuTLSAppInit      (const char* config);
int xmlSecGnuTLSAppShutdown        (void);

int xmlSecGnuTLSInit                (void);
int xmlSecGnuTLSShutdown            (void);
]]

if ffi.os == "Windows" and ffi.arch == "x64" then
	ffi.cdef[[
		typedef size_t xmlSecSize; // size_t will cause 32 bit or OSX versions to fail in verify
	]]
else
	ffi.cdef[[ // unsigned int will cause Windows 64 bit version to fail in verify
		typedef unsigned int xmlSecSize;
	]]
end

ffi.cdef[[
// #define xmlSecByte unsigned char // One byte. Should be typedef instead of define
typedef unsigned char xmlSecByte;
typedef unsigned int                            xmlSecTransformUriType;

typedef unsigned int            xmlSecKeyDataUsage;
typedef unsigned int            xmlSecKeyDataType;
typedef unsigned int            xmlSecKeyUsage;

typedef enum {
    xmlSecAllocModeExact = 0,
    xmlSecAllocModeDouble
} xmlSecAllocMode;

typedef enum  {
    xmlSecTransformOperationNone = 0,
    xmlSecTransformOperationEncode,
    xmlSecTransformOperationDecode,
    xmlSecTransformOperationSign,
    xmlSecTransformOperationVerify,
    xmlSecTransformOperationEncrypt,
    xmlSecTransformOperationDecrypt
} xmlSecTransformOperation;

typedef enum {
    xmlSecDSigStatusUnknown = 0,
    xmlSecDSigStatusSucceeded,
    xmlSecDSigStatusInvalid
} xmlSecDSigStatus;

typedef enum {
    xmlSecKeyInfoModeRead = 0,
    xmlSecKeyInfoModeWrite
} xmlSecKeyInfoMode;

typedef enum {
    xmlEncCtxModeEncryptedData = 0,
    xmlEncCtxModeEncryptedKey
} xmlEncCtxMode;

]]

ffi.cdef[[
// Forward declarations

typedef struct _xmlSecBuffer                    xmlSecBuffer, *xmlSecBufferPtr;
typedef struct _xmlSecEncCtx                    xmlSecEncCtx, *xmlSecEncCtxPtr;

typedef struct _xmlSecKeyData                   xmlSecKeyData, *xmlSecKeyDataPtr;
typedef struct _xmlSecKeyDataStore              xmlSecKeyDataStore, *xmlSecKeyDataStorePtr;
typedef const struct _xmlSecKeyDataKlass        xmlSecKeyDataKlass, *xmlSecKeyDataId;
typedef const struct _xmlSecKeyDataStoreKlass   xmlSecKeyDataStoreKlass, *xmlSecKeyDataStoreId;

typedef struct _xmlSecKeyInfoCtx                xmlSecKeyInfoCtx, *xmlSecKeyInfoCtxPtr;
typedef struct _xmlSecKey                       xmlSecKey, *xmlSecKeyPtr;
typedef struct _xmlSecKeyStore                  xmlSecKeyStore, *xmlSecKeyStorePtr;
typedef struct _xmlSecKeysMngr                  xmlSecKeysMngr, *xmlSecKeysMngrPtr;
typedef struct _xmlSecKeyReq                    xmlSecKeyReq, *xmlSecKeyReqPtr;

typedef struct _xmlSecTransform                 xmlSecTransform, *xmlSecTransformPtr;
typedef struct _xmlSecTransformCtx              xmlSecTransformCtx, *xmlSecTransformCtxPtr;
typedef const struct _xmlSecTransformKlass      xmlSecTransformKlass, *xmlSecTransformId;
typedef int (*xmlSecTransformCtxPreExecuteCallback)         (xmlSecTransformCtxPtr transformCtx);

// typedef struct _xmlSecKeyDataList               xmlSecKeyDataList, *xmlSecKeyDataListPtr;
typedef const struct _xmlSecPtrListKlass        xmlSecPtrListKlass, *xmlSecPtrListId;
typedef struct _xmlSecPtrList                   xmlSecPtrList, *xmlSecPtrListPtr;
]]

ffi.cdef[[
struct _xmlSecBuffer {
    xmlSecByte*         data;
    xmlSecSize          size;
    xmlSecSize          maxSize;
    xmlSecAllocMode     allocMode;
};

typedef void* xmlSecPtr;
typedef xmlSecPtr               (*xmlSecPtrDuplicateItemMethod) (xmlSecPtr ptr);
typedef void                    (*xmlSecPtrDestroyItemMethod)   (xmlSecPtr ptr);
typedef void                    (*xmlSecPtrDebugDumpItemMethod) (xmlSecPtr ptr, FILE* output);
struct _xmlSecPtrListKlass {
    const xmlChar*                      name;
    xmlSecPtrDuplicateItemMethod        duplicateItem;
    xmlSecPtrDestroyItemMethod          destroyItem;
    xmlSecPtrDebugDumpItemMethod        debugDumpItem;
    xmlSecPtrDebugDumpItemMethod        debugXmlDumpItem;
};
struct _xmlSecPtrList {
    xmlSecPtrListId             id;

    xmlSecPtr*                  data;
    xmlSecSize                  use;
    xmlSecSize                  max;
    xmlSecAllocMode             allocMode;
};
]]

ffi.cdef[[
typedef enum {
    xmlSecNodeSetNormal = 0,
    xmlSecNodeSetInvert,
    xmlSecNodeSetTree,
    xmlSecNodeSetTreeWithoutComments,
    xmlSecNodeSetTreeInvert,
    xmlSecNodeSetTreeWithoutCommentsInvert,
    xmlSecNodeSetList
} xmlSecNodeSetType;
typedef enum {
    xmlSecNodeSetIntersection = 0,
    xmlSecNodeSetSubtraction,
    xmlSecNodeSetUnion
} xmlSecNodeSetOp;

typedef struct _xmlSecNodeSet   xmlSecNodeSet, *xmlSecNodeSetPtr;
struct _xmlSecNodeSet {
    xmlNodeSetPtr       nodes;
    xmlDocPtr           doc;
    int                 destroyDoc;
    xmlSecNodeSetType   type;
    xmlSecNodeSetOp     op;
    xmlSecNodeSetPtr    next;
    xmlSecNodeSetPtr    prev;
    xmlSecNodeSetPtr    children;
};
]]

ffi.cdef[[
typedef xmlSecByte                              xmlSecTransformDataType;
typedef unsigned int                            xmlSecTransformUsage;
typedef enum  {
    xmlSecTransformModeNone = 0,
    xmlSecTransformModePush,
    xmlSecTransformModePop
} xmlSecTransformMode;
typedef enum  {
    xmlSecTransformStatusNone = 0,
    xmlSecTransformStatusWorking,
    xmlSecTransformStatusFinished,
    xmlSecTransformStatusOk,
    xmlSecTransformStatusFail
} xmlSecTransformStatus;

struct _xmlSecTransform {
    xmlSecTransformId                   id;
    xmlSecTransformOperation            operation;
    xmlSecTransformStatus               status;
    xmlNodePtr                          hereNode;

    /* transforms chain */
    xmlSecTransformPtr                  next;
    xmlSecTransformPtr                  prev;

    /* binary data */
    xmlSecBuffer                        inBuf;
    xmlSecBuffer                        outBuf;

    /* xml data */
    xmlSecNodeSetPtr                    inNodes;
    xmlSecNodeSetPtr                    outNodes;

    /* reserved for the future */
    void*                               reserved0;
    void*                               reserved1;
};
struct _xmlSecTransformCtx {
    /* user settings */
    void*                                       userData;
    unsigned int                                flags;
    unsigned int                                flags2;
    xmlSecTransformUriType                      enabledUris;
    xmlSecPtrList                               enabledTransforms;
    xmlSecTransformCtxPreExecuteCallback        preExecCallback;

    /* results */
    xmlSecBufferPtr                             result;
    xmlSecTransformStatus                       status;
    xmlChar*                                    uri;
    xmlChar*                                    xptrExpr;
    xmlSecTransformPtr                          first;
    xmlSecTransformPtr                          last;

    /* for the future */
    void*                                       reserved0;
    void*                                       reserved1;
};

typedef int             (*xmlSecTransformInitializeMethod)      (xmlSecTransformPtr transform);
typedef void            (*xmlSecTransformFinalizeMethod)        (xmlSecTransformPtr transform);
typedef int             (*xmlSecTransformNodeReadMethod)        (xmlSecTransformPtr transform,
                                                                 xmlNodePtr node,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef int             (*xmlSecTransformNodeWriteMethod)       (xmlSecTransformPtr transform,
                                                                 xmlNodePtr node,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef int             (*xmlSecTransformSetKeyRequirementsMethod)(xmlSecTransformPtr transform,
                                                                 xmlSecKeyReqPtr keyReq);

typedef int             (*xmlSecTransformSetKeyMethod)          (xmlSecTransformPtr transform,
                                                                 xmlSecKeyPtr key);
typedef int             (*xmlSecTransformVerifyMethod)          (xmlSecTransformPtr transform,
                                                                 const xmlSecByte* data,
                                                                 xmlSecSize dataSize,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef xmlSecTransformDataType (*xmlSecTransformGetDataTypeMethod)(xmlSecTransformPtr transform,
                                                                 xmlSecTransformMode mode,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef int             (*xmlSecTransformPushBinMethod)         (xmlSecTransformPtr transform,
                                                                 const xmlSecByte* data,
                                                                 xmlSecSize dataSize,
                                                                 int final,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef int             (*xmlSecTransformPopBinMethod)          (xmlSecTransformPtr transform,
                                                                 xmlSecByte* data,
                                                                 xmlSecSize maxDataSize,
                                                                 xmlSecSize* dataSize,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef int             (*xmlSecTransformPushXmlMethod)         (xmlSecTransformPtr transform,
                                                                 xmlSecNodeSetPtr nodes,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef int             (*xmlSecTransformPopXmlMethod)          (xmlSecTransformPtr transform,
                                                                 xmlSecNodeSetPtr* nodes,
                                                                 xmlSecTransformCtxPtr transformCtx);
typedef int             (*xmlSecTransformExecuteMethod)         (xmlSecTransformPtr transform,
                                                                 int last,
                                                                 xmlSecTransformCtxPtr transformCtx);


struct _xmlSecTransformKlass {
    /* data */
    xmlSecSize                          klassSize;
    xmlSecSize                          objSize;
    const xmlChar*                      name;
    const xmlChar*                      href;
    xmlSecTransformUsage                usage;

    /* methods */
    xmlSecTransformInitializeMethod     initialize;
    xmlSecTransformFinalizeMethod       finalize;

    xmlSecTransformNodeReadMethod       readNode;
    xmlSecTransformNodeWriteMethod      writeNode;

    xmlSecTransformSetKeyRequirementsMethod     setKeyReq;
    xmlSecTransformSetKeyMethod         setKey;
    xmlSecTransformVerifyMethod         verify;
    xmlSecTransformGetDataTypeMethod    getDataType;

    xmlSecTransformPushBinMethod        pushBin;
    xmlSecTransformPopBinMethod         popBin;
    xmlSecTransformPushXmlMethod        pushXml;
    xmlSecTransformPopXmlMethod         popXml;

    /* low level method */
    xmlSecTransformExecuteMethod        execute;

    /* reserved for future */
    void*                               reserved0;
    void*                               reserved1;
};
]]

ffi.cdef[[
typedef const struct _xmlSecKeyStoreKlass               xmlSecKeyStoreKlass, *xmlSecKeyStoreId;
typedef int                     (*xmlSecKeyStoreInitializeMethod)       (xmlSecKeyStorePtr store);
typedef void                    (*xmlSecKeyStoreFinalizeMethod)         (xmlSecKeyStorePtr store);
typedef xmlSecKeyPtr            (*xmlSecKeyStoreFindKeyMethod)  (xmlSecKeyStorePtr store,
                                                                 const xmlChar* name,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);

struct _xmlSecKeyStoreKlass {
    xmlSecSize                          klassSize;
    xmlSecSize                          objSize;

    /* data */
    const xmlChar*                      name;

    /* constructors/destructor */
    xmlSecKeyStoreInitializeMethod      initialize;
    xmlSecKeyStoreFinalizeMethod        finalize;
    xmlSecKeyStoreFindKeyMethod         findKey;

    /* for the future */
    void*                               reserved0;
    void*                               reserved1;
};

struct _xmlSecKey {
    xmlChar*                            name;
    xmlSecKeyDataPtr                    value;
    xmlSecPtrListPtr                    dataList;
    xmlSecKeyUsage                      usage;
    time_t                              notValidBefore;
    time_t                              notValidAfter;
};
]]

ffi.cdef[[
struct _xmlSecKeyStore {
    xmlSecKeyStoreId                    id;

    /* for the future */
    void*                               reserved0;
    void*                               reserved1;
};
struct _xmlSecKeyReq {
    xmlSecKeyDataId             keyId;
    xmlSecKeyDataType           keyType;
    xmlSecKeyUsage              keyUsage;
    xmlSecSize                  keyBitsSize;
    xmlSecPtrList               keyUseWithList;

    void*                       reserved1;
    void*                       reserved2;
};
typedef xmlSecKeyPtr    (*xmlSecGetKeyCallback)         (xmlNodePtr keyInfoNode, xmlSecKeyInfoCtxPtr keyInfoCtx);
struct _xmlSecKeysMngr {
    xmlSecKeyStorePtr           keysStore;
    xmlSecPtrList               storesList;
    xmlSecGetKeyCallback        getKey;
};
]]

ffi.cdef[[
struct _xmlSecKeyInfoCtx {
    void*                               userData;
    unsigned int                        flags;
    unsigned int                        flags2;
    xmlSecKeysMngrPtr                   keysMngr;
    xmlSecKeyInfoMode                   mode;
    xmlSecPtrList                       enabledKeyData;
    int                                 base64LineSize;

    /* RetrievalMethod */
    xmlSecTransformCtx                  retrievalMethodCtx;
    int                                 maxRetrievalMethodLevel;

    /* EncryptedKey */
    xmlSecEncCtxPtr                     encCtx;
    int                                 maxEncryptedKeyLevel;
    /* x509 certificates */
    time_t                              certsVerificationTime;
    int                                 certsVerificationDepth;

    /* PGP */
    void*                               pgpReserved;    /* todo */

    /* internal data */
    int                                 curRetrievalMethodLevel;
    int                                 curEncryptedKeyLevel;
    xmlSecKeyReq                        keyReq;

    /* for the future */
    void*                               reserved0;
    void*                               reserved1;
};
]]

ffi.cdef[[
struct _xmlSecKeyData {
    xmlSecKeyDataId                     id;
    void*                               reserved0;
    void*                               reserved1;
};
struct _xmlSecKeyDataStore {
    xmlSecKeyDataStoreId                id;

    /* for the future */
    void*                               reserved0;
    void*                               reserved1;
};

typedef int                     (*xmlSecKeyDataInitMethod)      (xmlSecKeyDataPtr data);
typedef int                     (*xmlSecKeyDataDuplicateMethod) (xmlSecKeyDataPtr dst,
                                                                 xmlSecKeyDataPtr src);
typedef void                    (*xmlSecKeyDataFinalizeMethod)  (xmlSecKeyDataPtr data);
typedef int                     (*xmlSecKeyDataGenerateMethod)  (xmlSecKeyDataPtr data,
                                                                 xmlSecSize sizeBits,
                                                                 xmlSecKeyDataType type);
typedef xmlSecKeyDataType       (*xmlSecKeyDataGetTypeMethod)   (xmlSecKeyDataPtr data);
typedef xmlSecSize              (*xmlSecKeyDataGetSizeMethod)   (xmlSecKeyDataPtr data);
typedef const xmlChar*          (*xmlSecKeyDataGetIdentifierMethod) (xmlSecKeyDataPtr data);
typedef int                     (*xmlSecKeyDataXmlReadMethod)   (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 xmlNodePtr node,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef int                     (*xmlSecKeyDataXmlWriteMethod)  (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 xmlNodePtr node,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef int                     (*xmlSecKeyDataBinReadMethod)   (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 const xmlSecByte* buf,
                                                                 xmlSecSize bufSize,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef int                     (*xmlSecKeyDataBinWriteMethod)  (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 xmlSecByte** buf,
                                                                 xmlSecSize* bufSize,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef int                     (*xmlSecKeyDataGenerateMethod)  (xmlSecKeyDataPtr data,
                                                                 xmlSecSize sizeBits,
                                                                 xmlSecKeyDataType type);
typedef void                    (*xmlSecKeyDataDebugDumpMethod) (xmlSecKeyDataPtr data,
                                                                 FILE* output);


struct _xmlSecKeyDataKlass {
    xmlSecSize                          klassSize;
    xmlSecSize                          objSize;

    /* data */
    const xmlChar*                      name;
    xmlSecKeyDataUsage                  usage;
    const xmlChar*                      href;
    const xmlChar*                      dataNodeName;
    const xmlChar*                      dataNodeNs;

    /* constructors/destructor */
    xmlSecKeyDataInitMethod             initialize;
    xmlSecKeyDataDuplicateMethod        duplicate;
    xmlSecKeyDataFinalizeMethod         finalize;
    xmlSecKeyDataGenerateMethod         generate;

    /* get info */
    xmlSecKeyDataGetTypeMethod          getType;
    xmlSecKeyDataGetSizeMethod          getSize;
    xmlSecKeyDataGetIdentifierMethod    getIdentifier;

    /* read/write */
    xmlSecKeyDataXmlReadMethod          xmlRead;
    xmlSecKeyDataXmlWriteMethod         xmlWrite;
    xmlSecKeyDataBinReadMethod          binRead;
    xmlSecKeyDataBinWriteMethod         binWrite;

    /* debug */
    xmlSecKeyDataDebugDumpMethod        debugDump;
    xmlSecKeyDataDebugDumpMethod        debugXmlDump;

    /* for the future */
    void*                               reserved0;
    void*                               reserved1;
};


typedef int                     (*xmlSecKeyDataStoreInitializeMethod)   (xmlSecKeyDataStorePtr store);
typedef void                    (*xmlSecKeyDataStoreFinalizeMethod)     (xmlSecKeyDataStorePtr store);

struct _xmlSecKeyDataStoreKlass {
    xmlSecSize                          klassSize;
    xmlSecSize                          objSize;

    /* data */
    const xmlChar*                      name;

    /* constructors/destructor */
    xmlSecKeyDataStoreInitializeMethod  initialize;
    xmlSecKeyDataStoreFinalizeMethod    finalize;

    /* for the future */
    void*                               reserved0;
    void*                               reserved1;
};
]]

ffi.cdef[[
struct _xmlSecEncCtx {
    /* these data user can set before performing the operation */
    void*                       userData;
    unsigned int                flags;
    unsigned int                flags2;
    xmlEncCtxMode               mode;
    xmlSecKeyInfoCtx            keyInfoReadCtx;
    xmlSecKeyInfoCtx            keyInfoWriteCtx;
    xmlSecTransformCtx          transformCtx;
    xmlSecTransformId           defEncMethodId;

    /* these data are returned */
    xmlSecKeyPtr                encKey;
    xmlSecTransformOperation    operation;
    xmlSecBufferPtr             result;
    int                         resultBase64Encoded;
    int                         resultReplaced;
    xmlSecTransformPtr          encMethod;

    /* attributes from EncryptedData or EncryptedKey */
    xmlChar*                    id;
    xmlChar*                    type;
    xmlChar*                    mimeType;
    xmlChar*                    encoding;
    xmlChar*                    recipient;
    xmlChar*                    carriedKeyName;

    /* these are internal data, nobody should change that except us */
    xmlNodePtr                  encDataNode;
    xmlNodePtr                  encMethodNode;
    xmlNodePtr                  keyInfoNode;
    xmlNodePtr                  cipherValueNode;

    xmlNodePtr                  replacedNodeList; /* the pointer to the replaced node */
    void*                       reserved1;        /* reserved for future */
};
]]


ffi.cdef[[

typedef int                     (*xmlSecKeyDataInitMethod)      (xmlSecKeyDataPtr data);
typedef int                     (*xmlSecKeyDataDuplicateMethod) (xmlSecKeyDataPtr dst,
                                                                 xmlSecKeyDataPtr src);
typedef void                    (*xmlSecKeyDataFinalizeMethod)  (xmlSecKeyDataPtr data);
typedef int                     (*xmlSecKeyDataGenerateMethod)  (xmlSecKeyDataPtr data,
                                                                 xmlSecSize sizeBits,
                                                                 xmlSecKeyDataType type);
typedef xmlSecKeyDataType       (*xmlSecKeyDataGetTypeMethod)   (xmlSecKeyDataPtr data);
typedef xmlSecSize              (*xmlSecKeyDataGetSizeMethod)   (xmlSecKeyDataPtr data);
typedef const xmlChar*          (*xmlSecKeyDataGetIdentifierMethod) (xmlSecKeyDataPtr data);
typedef int                     (*xmlSecKeyDataXmlReadMethod)   (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 xmlNodePtr node,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef int                     (*xmlSecKeyDataXmlWriteMethod)  (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 xmlNodePtr node,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef int                     (*xmlSecKeyDataBinWriteMethod)  (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 xmlSecByte** buf,
                                                                 xmlSecSize* bufSize,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef int                     (*xmlSecKeyDataGenerateMethod)  (xmlSecKeyDataPtr data,
                                                                 xmlSecSize sizeBits,
                                                                 xmlSecKeyDataType type);
typedef int                     (*xmlSecKeyDataBinReadMethod)   (xmlSecKeyDataId id,
                                                                 xmlSecKeyPtr key,
                                                                 const xmlSecByte* buf,
                                                                 xmlSecSize bufSize,
                                                                 xmlSecKeyInfoCtxPtr keyInfoCtx);
typedef void                    (*xmlSecKeyDataDebugDumpMethod) (xmlSecKeyDataPtr data,
                                                                 FILE* output);

]]


ffi.cdef[[
typedef enum {
    xmlSecKeyDataFormatUnknown = 0,
    xmlSecKeyDataFormatBinary,
    xmlSecKeyDataFormatPem,
    xmlSecKeyDataFormatDer,
    xmlSecKeyDataFormatPkcs8Pem,
    xmlSecKeyDataFormatPkcs8Der,
    xmlSecKeyDataFormatPkcs12,
    xmlSecKeyDataFormatCertPem,
    xmlSecKeyDataFormatCertDer
} xmlSecKeyDataFormat;

const xmlChar xmlSecNodeSignature[];
const xmlChar xmlSecDSigNs[];
]]


ffi.cdef[[
typedef struct _xmlSecDSigCtx xmlSecDSigCtx, *xmlSecDSigCtxPtr;
struct _xmlSecDSigCtx {
    /* these data user can set before performing the operation */
    void*                       userData;
    unsigned int                flags;
    unsigned int                flags2;
    xmlSecKeyInfoCtx            keyInfoReadCtx;
    xmlSecKeyInfoCtx            keyInfoWriteCtx;
    xmlSecTransformCtx          transformCtx;
    xmlSecTransformUriType      enabledReferenceUris;
    xmlSecPtrListPtr            enabledReferenceTransforms;
    xmlSecTransformCtxPreExecuteCallback referencePreExecuteCallback;
    xmlSecTransformId           defSignMethodId;
    xmlSecTransformId           defC14NMethodId;
    xmlSecTransformId           defDigestMethodId;

    /* these data are returned */
    xmlSecKeyPtr                signKey;
    xmlSecTransformOperation    operation;
    xmlSecBufferPtr             result;
    xmlSecDSigStatus            status;
    xmlSecTransformPtr          signMethod;
    xmlSecTransformPtr          c14nMethod;
    xmlSecTransformPtr          preSignMemBufMethod;
    xmlNodePtr                  signValueNode;
    xmlChar*                    id;
    xmlSecPtrList               signedInfoReferences;
    xmlSecPtrList               manifestReferences;

    /* reserved for future */
    void*                       reserved0;
    void*                       reserved1;
};

]]

ffi.cdef[[
typedef enum  {
    xmlSecDSigReferenceOriginSignedInfo,
    xmlSecDSigReferenceOriginManifest
} xmlSecDSigReferenceOrigin;
typedef struct _xmlSecDSigReferenceCtx          xmlSecDSigReferenceCtx,
                                                *xmlSecDSigReferenceCtxPtr;
struct _xmlSecDSigReferenceCtx {
    void*                       userData;
    xmlSecDSigCtxPtr            dsigCtx;
    xmlSecDSigReferenceOrigin   origin;
    xmlSecTransformCtx          transformCtx;
    xmlSecTransformPtr          digestMethod;

    xmlSecBufferPtr             result;
    xmlSecDSigStatus            status;
    xmlSecTransformPtr          preDigestMemBufMethod;
    xmlChar*                    id;
    xmlChar*                    uri;
    xmlChar*                    type;

     /* reserved for future */
    void*                       reserved0;
    void*                       reserved1;
};
]]

ffi.cdef[[
// /Users/pasi/ma-git/other/c/xmlsec/include/libxml/parser.h
void xmlInitParser		(void);
void xmlCleanupParser	(void);
xmlDocPtr 	xmlParseFile(const char *filename);
xmlDocPtr         xmlSecParseMemory       (const xmlSecByte *buffer,
                                                         xmlSecSize size,
                                                         int recovery);
int xmlDocDump	(FILE *f, xmlDocPtr cur);
void xmlDocDumpMemory		(xmlDocPtr cur, xmlChar ** mem, int * size);
void xmlFreeDoc(xmlDocPtr cur);
void xmlFree(void *mem);

xmlNodePtr	xmlDocGetRootElement(const xmlDoc *doc);
xmlNodePtr	xmlSecFindNode          (const xmlNodePtr parent,
                                                         const xmlChar *name,
																												const xmlChar *ns);
xmlSecDSigCtxPtr  xmlSecDSigCtxCreate             (xmlSecKeysMngrPtr keysMngr);
xmlSecKeyPtr xmlSecOpenSSLAppKeyLoad         (const char *filename, xmlSecKeyDataFormat format,
                                                                         const char *pwd,
                                                                         void* pwdCallback,
                                                                         void* pwdCallbackCtx);
xmlSecKeyPtr xmlSecOpenSSLAppKeyLoadMemory (const xmlSecByte *data,
                               xmlSecSize dataSize,
                               xmlSecKeyDataFormat format,
                               const char *pwd,
                               void *pwdCallback,
                               void *pwdCallbackCtx);

xmlSecKeyPtr xmlSecOpenSSLAppPkcs12Load (const char *filename,
                            const char *pwd,
                            void *pwdCallback,
                            void *pwdCallbackCtx);
xmlSecKeyPtr xmlSecOpenSSLAppPkcs12LoadMemory
								(const xmlSecByte *data,
								 xmlSecSize dataSize,
								 const char *pwd,
								 void *pwdCallback,
								 void *pwdCallbackCtx);


xmlSecKeyPtr xmlSecGnuTLSAppKeyLoad         (const char *filename, xmlSecKeyDataFormat format,
                                                                         const char *pwd,
                                                                         void* pwdCallback,
                                                                         void* pwdCallbackCtx);
xmlSecKeyPtr xmlSecGnuTLSAppKeyLoadMemory (const xmlSecByte *data,
                               xmlSecSize dataSize,
                               xmlSecKeyDataFormat format,
                               const char *pwd,
                               void *pwdCallback,
                               void *pwdCallbackCtx);

xmlSecKeyPtr xmlSecGnuTLSAppPkcs12Load (const char *filename,
                            const char *pwd,
                            void *pwdCallback,
                            void *pwdCallbackCtx);
xmlSecKeyPtr xmlSecGnuTLSAppPkcs12LoadMemory
								(const xmlSecByte *data,
								 xmlSecSize dataSize,
								 const char *pwd,
								 void *pwdCallback,
								 void *pwdCallbackCtx);

int               xmlSecKeySetName        (xmlSecKeyPtr key,
                                                         const xmlChar* name);
int               xmlSecDSigCtxSign               (xmlSecDSigCtxPtr dsigCtx,
                                                                 xmlNodePtr tmpl);
int               xmlSecDSigCtxVerify             (xmlSecDSigCtxPtr dsigCtx,
                                                                 xmlNodePtr node);
void xmlSecDSigCtxDestroy(xmlSecDSigCtxPtr dsigCtx);

int xmlSecKeySetName (xmlSecKeyPtr key,
                  const xmlChar *name);
int xmlSecDSigCtxInitialize (xmlSecDSigCtxPtr dsigCtx,
                         xmlSecKeysMngrPtr keysMngr);

xmlSecKeyPtr       xmlSecOpenSSLAppKeyLoadMemory   (const xmlSecByte* data,
                                                                         xmlSecSize dataSize,
                                                                         xmlSecKeyDataFormat format,
                                                                         const char *pwd,
                                                                         void* pwdCallback,
                                                                         void* pwdCallbackCtx);
xmlSecKeyPtr xmlSecCryptoAppKeyLoadMemory (const xmlSecByte *data,
                              xmlSecSize dataSize,
                              xmlSecKeyDataFormat format,
                              const char *pwd,
                              void *pwdCallback,
                              void *pwdCallbackCtx);

xmlSecKeyPtr       xmlSecGnuTLSAppKeyLoadMemory   (const xmlSecByte* data,
                                                                         xmlSecSize dataSize,
                                                                         xmlSecKeyDataFormat format,
                                                                         const char *pwd,
                                                                         void* pwdCallback,
                                                                         void* pwdCallbackCtx);
xmlSecKeyPtr xmlSecCryptoAppKeyLoadMemory (const xmlSecByte *data,
                              xmlSecSize dataSize,
                              xmlSecKeyDataFormat format,
                              const char *pwd,
                              void *pwdCallback,
                              void *pwdCallbackCtx);

xmlSecKeysMngrPtr         xmlSecKeysMngrCreate            (void);
void                      xmlSecKeysMngrDestroy           (xmlSecKeysMngrPtr mngr);
int                xmlSecOpenSSLAppDefaultKeysMngrInit(xmlSecKeysMngrPtr mngr);
int                xmlSecOpenSSLAppDefaultKeysMngrAdoptKey(xmlSecKeysMngrPtr mngr, xmlSecKeyPtr key);
int                xmlSecGnuTLSAppDefaultKeysMngrInit(xmlSecKeysMngrPtr mngr);
int                xmlSecGnuTLSAppDefaultKeysMngrAdoptKey(xmlSecKeysMngrPtr mngr, xmlSecKeyPtr key);

int               xmlSecDSigCtxInitialize         (xmlSecDSigCtxPtr dsigCtx, xmlSecKeysMngrPtr keysMngr);
void              xmlSecDSigCtxFinalize           (xmlSecDSigCtxPtr dsigCtx);

xmlDocPtr         xmlSecParseFile         (const char *filename);
xmlDocPtr         xmlSecParseMemory       (const xmlSecByte *buffer,
                                                         xmlSecSize size,
                                                         int recovery);

xmlSecSize        xmlSecPtrListGetSize            (xmlSecPtrListPtr list);
xmlSecPtr         xmlSecPtrListGetItem            (xmlSecPtrListPtr list, xmlSecSize pos);

typedef void (*xmlFreeFunc)(void *mem);
typedef void *(*xmlMallocFunc)(size_t size);
typedef void *(*xmlReallocFunc)(void *mem, size_t size);
typedef char *(*xmlStrdupFunc)(const char *str);
int xmlMemGet	(xmlFreeFunc *freeFunc,
			 xmlMallocFunc *mallocFunc,
			 xmlReallocFunc *reallocFunc,
			 xmlStrdupFunc *strdupFunc);
typedef struct _xmlGlobalState xmlGlobalState;
typedef xmlGlobalState *xmlGlobalStatePtr;
struct _xmlGlobalState
{
	xmlFreeFunc xmlFree;
	xmlMallocFunc xmlMalloc;
	xmlStrdupFunc xmlMemStrdup;
	xmlReallocFunc xmlRealloc;
};
]]

require "xmlsec_xslt" -- needs xml definitions first

return {}
