// preference/form/nc/nc-define/nc-layout-editor/nc-layout-content.js
// see: https://css-tricks.com/animation-techniques-for-adding-and-removing-items-from-a-stack/

// @mouseenter.stop='mouseEnter',
// @mouseleave.stop='mouseLeave'
// import '/src/style/nc-transition.scss' // .nc-draw-content-move { transition: transform 0.15s }
// import { dragOptions } from './nc-layout-drag-drop.js'
// import { rowColStyle } from './nc-form-col-row.js'
// import Hammer from 'hammerjs'
// import('/src/directives/nc-drag-drop.js')
// const nc-drag-drop = resolveDirective('nc-drag-drop')

// import '/src/directives/nc-drag-drop.js' // uses app.directive to generate global directive
import { dragOptions } from '/plugin/nc-layout-editor/nc-layout-drag-drop.js'
import { isContainer, deleteNodeContent, hoverBoxStyle } from '/plugin/nc-layout-editor/nc-layout-editor-util.js' // isContainer is used in html

const layoutEvent = inject('layout-event')
// eslint-disable-next-line no-unused-vars
const ddCont = Object.assign({}, dragOptions, { drag: true, drop: true, type: 'container' }) // ddCont adn ddElem are used in html
// eslint-disable-next-line no-unused-vars
const ddElem = Object.assign({}, dragOptions, { drag: true, drop: false, type: 'container' })

const props = defineProps({
	ncNode: {
		type: Object,
		required: true,
		default: undefined
	},
	ncParent: {
		type: Object,
		default: undefined
	},
	ncElem: {
		type: Object,
		default: undefined
	}
})

const displayNoneStyle = { display: 'none' }
// eslint-disable-next-line no-unused-vars
function isContainerNode(node) {
	return isContainer(node)
}

// const noHoverNode = {}
// eslint-disable-next-line no-unused-vars
function onHover(event) {
	// called from html
	state.rec.hover_node = props.ncNode
	const x = event.clientX
	const y = event.clientY
	const elem = document.elementFromPoint(x, y)
	if (!elem) {
		hoverBoxStyle.value = displayNoneStyle
	} else {
		const bounding = elem.getBoundingClientRect()
		hoverBoxStyle.value = {
			position: 'fixed',
			width: `${bounding.width}px`,
			height: `${bounding.height}px`,
			left: `${bounding.left}px`,
			top: `${bounding.top}px`,
			backgroundColor: '#3eaf7c44',
			pointerEvents: 'none',
			zIndex: 9999,
			transition: 'all 0.05s linear',
			border: '1px solid var(--c-brand)'
		}
	}
	/* pointStyle.value = {
		position: 'fixed',
		left: '0px',
		top: '0px',
		pointerEvents: 'none',
		zIndex: 9999,
		transform: `translate(calc(${x}px - 50%), calc(${y}px - 50%))`
	}
 	*/
}

// eslint-disable-next-line no-unused-vars
function onClick(event) {
	// we need both @click.native.stop='onClick' @click.stop='onClick' for dropdowns and textareas to work
	const ncNode = props.ncNode
	event.stopPropagation()
	event.preventDefault() // is needed to prevent button clicks to fire
	layoutEvent.value = {
		type: `onClick:element ${ncNode.component + ' ' + ncNode.id}`,
		ncNode: ncNode,
		event: event
	}
}

onMounted(function () {
	if (!props.ncNode.component) {
		return // this is ok, empty main object
	}
	const node = props.ncNode
	node.ncElem = getCurrentInstance()
})

onBeforeUnmount(function () {
	deleteNodeContent(props.ncNode)
})

// old dnd
/*
let dnd = null
let allowDrag = false
function mouseEnter() {
	/* if (event.target.ncNode) {
				console.log(`mouseEnter:element ${event.target.ncNode.component + ' ' + event.target.ncNode.id}`, event)
			} * /
	if (allowDrag) {
		// const hammer = new Hammer(this.$el)
		// hammer.on('panstart panend panleft panright panup pandown tap press', function (evt) {
		// 	if (debugMouse) console.log('Move event: ' + evt.type, evt)
		// })
		// dnd = hammer
	}
}

function mouseLeave() {
	// console.log('mouseLeave', event)
	// if (dnd) {
	// 	dnd.stop(true)
	// 	dnd.destroy()
	// 	// delete props.ncNode.dnd
	// }
} */
