// form/nc/report/form/form.js

const loadPdf = nc.debounce(loadPdfFunc, (rec.update_pdf_seconds && rec.update_pdf_seconds * 1000) || 200, false) // default delay of 200 ms

onMounted(() => {
	changeTab() // first data load
	watch(
		() => rec.pdf_update_trigger, // nc-include pages loadPdf() this by "v-on:change": "rec.pdf_update_trigger++"
		() => {
			loadPdf()
		}
	)
})

function showPdf(noDelay) {
	if (rec.show_pdf) {
		if (noDelay) {
			loadPdfFunc()
		} else {
			loadPdf()
		}
	}
}

function setRecord(item, noDelay) {
	nc.mergeState(state, 'rec', item, 'form/nc/report/form/form.js')
	const formRec = rec[rec.tab]
	if (formRec) {
		if (formRec.run_code) {
			nc.callServer(
				state,
				'run_code',
				{
					run_code: formRec.run_code,
					rec: rec
				},
				ret => {
					if (ret.rec) {
						nc.mergeState(state, 'rec', ret.rec, 'form/nc/report/form/form.js')
					}
					showPdf(noDelay)
				}
			)
		}
	} else {
		showPdf(noDelay)
	}
}

function pdfCallback(ret) {
	if (rec.show_pdf && ret && ret.page) {
		// ret.page is pdf render result
		const tab = state?.rec?.tab || 'Form'
		const tabShow = nc.recordArrayField(state.arr.tab, 'value', tab, 'show') || 'Form'
		rec.document_data = {
			data: ret.page,
			mime_type: 'application/pdf',
			document_name: tab === 'pallet-label' ? tabShow + '-' + rec.dispatch_note + '.pdf' : tabShow + '.pdf'
		}
		return
	}
}

function callback(ret) {
	pdfCallback(ret)
	const arr = state?.grid?.form_row?.data
	rec.pro = { json_data: {} }
	rec.pr = { json_data: {} }
	rec.co = { json_data: {} }
	if (arr && arr.length > 0) {
		setRecord(arr[0], true)
		nc.grid.activateRows(state, 'form_row', 1)
	}
}

// eslint-disable-next-line no-unused-vars
function gridRowClicked(area, rowIndex, event, selected) {
	if (selected) {
		setRecord(event.data, true)
	}
}

function loadPdfFunc() {
	if (rec.show_pdf) {
		nc.callServer(
			state,
			'print',
			{
				render_preference: {
					document_type: 'pdf',
					paper_type: rec.paper_type,
					paper_orientation: (rec.landscape && 'landscape') || 'portrait'
				},
				component: rec.layout_component,
				state: {
					rec: rec,
					hdr: hdr
				}
			},
			pdfCallback
		)
	}
}

function changeTab() {
	rec.layout_component = 'form/nc/report/form/' + rec.tab
	const arrItem = arr.tab.find(item => item.value === rec.tab)
	if (arrItem && arrItem.paper_type) {
		rec.paper_type = arrItem.paper_type
	}
	if (arrItem && arrItem.landscape != null) {
		rec.landscape = arrItem.landscape
	}
	update()
}

// eslint-disable-next-line no-unused-vars
function print() {
	const formRec = rec[rec.tab]
	if (formRec && formRec.run_print_code) {
		nc.callServer(
			state,
			'run_code',
			{
				run_code: formRec.run_print_code,
				rec: rec,
				hdr: hdr
			} /* ,
				ret => {
					if (ret.rec) {
						nc.mergeState(state, 'rec', ret.rec, 'form/nc/report/form/form.js')
					}
					showPdf(noDelay)
				} */
		)
	}
}

function update() {
	const param = {
		invoice: rec.invoice,
		dispatch_note: rec.dispatch_note,
		program_number: rec.program_number,
		production_order: rec.production_order,
		start_date: rec.start_date,
		invoice_start_date: rec.invoice_start_date,
		production_order_state_skip: rec.production_order_state_skip
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/report/form/grid.json',
			return: {
				grid: [
					{
						name: 'form_row',
						tab: rec.tab
					}
				]
			},
			parameter: param
		},
		callback
	)
}
