// form/nc/nc-load/nc-load.js
if (!state.rec.gantt_data?.resource) {
	update('first-load')
}

function update(action) {
	if (action == 'capacity' && state.rec.old_capacity) {
		state.rec.old_work_date = true
	}
	if (action == 'work_date' && state.rec.old_work_date) {
		state.rec.old_capacity = true
		action = 'capacity'
	}
	if (action !== 'work_date') {
		let oldRec
		if (action !== 'first-load') {
			oldRec = nc.clone(state.rec)
		}
		nc.callServer(state, 'calc/loading', { old_capacity: state.rec.old_capacity, reload_data: state.rec.reload_data }, ret => {
			if (oldRec) {
				state.rec = oldRec
			}
			if (!ret.grid) {
				message.setWarning(state, `Return grid was not found.`)
				return
			}
			if (state.rec && ret.grid?.gridIdx?.capacityIdx) {
				state.rec.gantt_data = {
					work_phase: ret.grid?.['product_work-schedule']?.data,
					resource: ret.grid?.['resource-load_group']?.data,
					product: ret.grid?.['product']?.data,
					capacityIdx: ret.grid.gridIdx.capacityIdx
				}
			}
		})
	}
}

onMounted(() => {
	watch(
		() => rec.only_open + rec.only_started * 10 + rec.show_connection * 100 + rec.show_first_work * 1000, // track all values together, boolean will be converted to 0 or 1: 0, 1, 10, 11, ...
		newValue => {
			rec.gantt_update = newValue
		}
	)
})
