// nc-input/nc-translate.js
// /src/components/nc-input/nc-translate.js
// // import '/src/components/nc-input/nc-input.vue' // need '/src/lib/fomantic-ui/dist/components/label.css
// import { rowColStyle } from './nc-form-col-row.js'

import { inject, computed, ref, onMounted, getCurrentInstance } from '../../vuelib.js' // server component must have vue imports

export default function createComponent(name) {
	// export default function createComponent(name, defaultWidth) {
	return {
		name: name,
		props: {
			model: {
				type: String,
				default: undefined,
				required: false // unlike elsewhere model is not required if hdr exists
			},
			hdr: {
				type: String,
				default: undefined
			},
			width: {
				type: String,
				default: undefined
			},
			height: {
				type: String,
				default: undefined
			},
			labelStyle: {
				type: [Object, String],
				default: undefined
			}
		},
		setup(props) {
			// calculatedStyle = rowColStyle(this, defaultWidth) // true == set default width:100%;
			const state = inject('state')
			const calculatedStyle = ref('')
			const styleClass = ref(name)
			if (props.disabled) {
				styleClass.value = styleClass.value + ' nc-disabled'
			}
			if (name === 'nc-translate') {
				styleClass.value = 'nc-translate-vue'
			}

			if (typeof window !== 'undefined') {
				// server render fix
				onMounted(function () {
					const model = props.hdr || props.model
					if (model == null) {
						const elem = getCurrentInstance()
						console.warn(`nc-translate component 'hdr' and 'model' -properties are missing, you must have at least one`, props, elem.vnode.el)
					}
				})
			}

			const langLabel = computed(() => {
				const model = props.hdr || props.model
				if (!model) {
					return
				} else {
					let arr = model.split('.')
					if (arr[0] !== 'hdr' && arr[0] !== 'rec') {
						console.warn('nc-translate model does not start with hdr or rec')
					}
					arr.shift() // remove first element "hdr" or "rec"
					let hdrRec = state.hdr
					for (let i = 0; i < arr.length; i++) {
						let key = arr[i]
						if (hdrRec && hdrRec[key] == null) {
							let pos1 = key.indexOf('[')
							if (pos1 >= 0) {
								let pos2 = key.indexOf(']')
								let index = key.substring(pos1 + 1, pos2)
								index = parseInt(index)
								let hdr2 = null
								if (index >= 0) {
									let key2 = key.substring(0, pos1)
									let hdr2 = hdrRec[key2] && hdrRec[key2][index]
									if (typeof hdr2 === 'string') {
										hdrRec = hdr2
										console.debug('indexed header was found: ' + props.model + ' = ' + hdrRec)
									} else {
										hdr2 = null
									}
								}
								if (!hdr2) {
									console.warn('indexed header was not found: ' + props.model)
									return null
								}
							}
						} else if (typeof hdrRec === 'object') {
							hdrRec = hdrRec[key] // nosemgrep
						}
					}
					if (typeof hdrRec === 'string') {
						return hdrRec || ' ' // problem with '' being same as null in js if-clause, so return ' ' if hdrRec is ''
					}
					return null
				}
			})
			return { calculatedStyle, styleClass, langLabel }
		}
	}
}
