// plugin/vue-renderer/server.js

/* see: https://medium.com/js-dojo/whats-new-in-vue-3-d17e98b8867e

*/

import http from 'http'
import createApp from './ssr/app.js'

const port = 8082
const host = 'localhost'

const server = http.createServer(async (req, res) => {
	if (req.url.endsWith('.ico')) {
		res.end('')
		return
	}
	const html = await createApp(req)
	res.end(html)
})

server.listen(port, host, () => {
	console.log(`🚀 vue-renderer/server.js is running on http://${host}:${port}\n`)
})
