// form/nc/nc-stock/nc-stock.js

const recDataCopy = nc.recDataCopy
const packetDefault = nc.clone(rec.packet)
let rowIndex = 0

/* onMounted(() => {
	nc.grid.activateRows(state, 'stock', 1)
	gridRowClicked('stock', 1, null, true)
}) */

function copyOrderRowFieldToPacket() {
	const fromData = nc.grid.activatedRow(state, 'stock_row') // nc.grid.activatedRecordArr(state, 'stock_row')
	const packet = rec.packet
	for (const key in packetDefault) {
		// set default values to packet
		recDataCopy(packetDefault, key, packet, key)
	}
	for (const item of rec.copy_order_row_field_to_packet) {
		// copy from row to packet

		recDataCopy(fromData, item.from, packet, item.to)
	}
}

// eslint-disable-next-line no-unused-vars
function updatePacket(changedField) {
	const packet = rec.packet
	if (packet.packet_count <= 0 || packet.total_amount <= 0) {
		packet.full_packet_size = 0
		packet.full_packet_size2 = 0
		packet.last_packet_size = 0
		return
	}
	debugger
	packet[changedField] = Number(packet[changedField]) // change entered value to number
	if (changedField === 'packet_count') {
		packet.full_packet_size = Math.trunc(packet.total_amount / packet.packet_count)
		packet.last_packet_size = packet.total_amount - packet.packet_count * packet.full_packet_size
	} else if (changedField === 'full_packet_size') {
		packet.last_packet_size = packet.total_amount - packet.packet_count * packet.full_packet_size
	} else if (changedField === 'full_packet_size2') {
		packet.full_packet_size = Math.trunc(packet.total_amount / packet.packet_count)
		packet.last_packet_size = packet.total_amount - packet.packet_count * packet.full_packet_size
	} else if (changedField === 'packet_count2') {
		packet.full_packet_size = Math.trunc(packet.total_amount / packet.packet_count)
		packet.last_packet_size = packet.total_amount - packet.packet_count * packet.full_packet_size
	} else if (changedField === 'last_packet_size2') {
		packet.full_packet_size = Math.trunc(packet.total_amount / packet.packet_count)
		packet.last_packet_size = packet.total_amount - packet.packet_count * packet.full_packet_size
	} else {
		message.setWarning(state, 'unknown field')
	}
	/*
	if (packet.full_packet_size === packet.last_packet_size) {
		packet.full_packet_size = packet.full_packet_size + 1
		packet.last_packet_size = 0
	}
	if (packet.last_packet_size < 0) {
		packet.packet_count = packet.packet_count - 1
		// packet.full_packet_size = Math.trunc(packet.total_amount / packet.packet_count)
		// packet.last_packet_size = packet.total_amount - packet.packet_count * packet.full_packet_size
	}
	*/
}

// eslint-disable-next-line no-unused-vars
function createRow() {
	const packet = rec.packet
	const data = state.grid.stock_location.data
	debugger
	let rowNum = data.length
	for (let i = 1; i <= packet.packet_count; i++) {
		rowNum++
		const row = { idx: rowNum }
		for (const item of rec.copy_packet_field_to_stock) {
			// todo: check logic
			if (i < packet.packet_count) {
				packet.save_amount = packet.full_packet_size
			} else {
				packet.save_amount = packet.last_packet_size
			}
			recDataCopy(packet, item.from, row, item.to)
		}
		data.push(row)
	}
	nc.grid.redrawGrid(state, 'stock_location')
}

// eslint-disable-next-line no-unused-vars
function save() {
	const saveData = state.grid.stock_location.data.filter(item => item.stock_id == null)
	console.debug(`🚀 ~ save data:`, saveData)
	if (saveData.length < 1) {
		message.setWarning(state, 'no stock location rows where stock id is empty, nothing to save')
		return
	}
	const param = { save: [{ table: 'stock', save_preference: 'form/nc/nc-stock/save/stock.json', data: saveData }] }
	nc.callServer(state, 'save', param, ret => {
		if (ret.status === 'ok') {
			message.setInfo(state, ret)
		}
		if (ret.result) {
			alert(ret.result)
		}
	})
}

// eslint-disable-next-line no-unused-vars
function update() {
	let tab = rec.tab
	const param = {
		tab: tab,
		transfer_id: rec.show_all_events ? '%' : '',
		search_product: rec.search_product
	}
	const gridParam = [
		{
			name: 'stock',
			tab: param.tab
		}
	]
	if (rec.tab === 'stock-receive' || rec.tab === 'stock-receive') {
		gridParam.push({
			name: 'stock_location'
		})
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/nc-stock/grid.json',
			return: { grid: gridParam },
			parameter: param
		},
		() => {
			if (rowIndex > 0 && rec.tab === 'product') {
				const data = state.grid?.stock?.data
				if (data && rowIndex > data.length) {
					rowIndex = 1
				}
			}
			nc.grid.activateRows(state, 'stock', rowIndex)
			gridRowClicked('stock', null, null, true)
		}
	)
}

function gridRowClicked(area, rowIndex, event, selected) {
	if (area === 'stock_row') {
		copyOrderRowFieldToPacket()
	} else if (selected && area === 'stock' && rec.tab === 'product') {
		const data = state.grid?.stock?.data
		const stockEvent = state.grid?.stock_location
		if (data && stockEvent) {
			rowIndex = event?.data?.idx || rowIndex
			if (rowIndex > 0 && rowIndex <= data.length) {
				rec.product_info = data[rowIndex - 1].info
				const newData = data[rowIndex - 1].stock_location || []
				nc.grid.dataChanged(stockEvent, newData)
			} else {
				nc.grid.dataChanged(stockEvent, [])
			}
		} else {
			nc.grid.dataChanged(stockEvent, [])
		}
		if (!selected) {
			rowIndex = 0
			nc.grid.dataChanged(stockEvent, [])
		}
	}
}

// eslint-disable-next-line no-unused-vars
function doesExternalFilterPass(node) {
	if (rec.show_all_events === false && node.data.idx !== 1 && !rec.stock_event_type_value_show[node.data.event_type]) {
		return false
	}
	return true
}

// eslint-disable-next-line no-unused-vars
function storageMapToggleSelected(param) {
	// console.debug('map click', param.id, param.event)
	/* const i = mapSelected.value.indexOf(param.id)
	if (i === -1) {
		mapSelected.value.push(param.id)
	} else {
		mapSelected.value.splice(i, 1)
	} */
}

// eslint-disable-next-line no-unused-vars
function storageMapDoubleClick(param) {
	// console.debug('map double click', param.id, param.event)
}
