// form/nc/report/delivery-reliability/delivery-reliability.js

function pageInit(ret) {
	const selectionId = nc.searchParameter('id')
	if (selectionId) {
		rec.query_type = 'selection'
		rec.selection_id = selectionId
	} else {
		rec.query_type = 'time_period'
		rec.selection_id = ''
	}
	callServerCallback(ret)
}

let updateTimeout
function callServerCallback() {
	// rec.query_type = queryType // restore after init call
	// rec.selection_id = selectionId
	rec.query_start_date = rec.start_date // in html, update button as red if out of date range
	rec.query_end_date = rec.end_date
	rec.query_warning = ''
	drawChart() // will call setDropdown(state, data)
	if (updateTimeout) {
		clearTimeout(updateTimeout)
	}
	if (rec.update_seconds > 0) {
		updateTimeout = setTimeout(() => {
			callServer('init')
		}, rec.update_seconds * 1000)
	}
}

function callServer() {
	// queryType = rec.query_type // save now and restore after rest call
	// selectionId = rec.selection_id
	// if (action === 'update') {
	let param = {
		return: {
			grid: [
				{
					name: 'order_row',
					tab: rec.table
				}
			]
		}
	}
	if (rec.query_type === 'selection') {
		param.selection_id = rec.selection_id
	} else {
		param.start_date = rec.start_date // dt.dateToString(rec.start_date),
		param.end_date = rec.end_date // dt.dateToString(rec.end_date)
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/report/delivery-reliability/grid.json',
			parameter: param
		},
		callServerCallback
	)
	// }
}

function setDropdown(state, data) {
	let date, item
	const companyFound = {}
	const filteredDropdown = data.filter(function (ordr) {
		// filter out data that is not in selected date range
		if (rec.query_type !== 'time_period') {
			return true
		}
		date = ordr.calc.target_date // nc.parseDate(ordr.calc.target_date)
		return date >= rec.start_date && date <= rec.end_date
	})
	const dropdown = filteredDropdown.reduce(function (result, ordr) {
		if (!companyFound[ordr.ord.company_id]) {
			item = {
				count: 1,
				show: ordr.co.name + ' - ' + ordr.ord.company_id,
				value: ordr.ord.company_id
			}
			companyFound[ordr.ord.company_id] = item
			// if data.find( (element) -> return element.ord.company_id is ordr.ord.company_id )
			result.push(item)
		} else {
			item = companyFound[ordr.ord.company_id]
			item.count = item.count + 1
		}
		return result
	}, [])
	dropdown.forEach(function (item) {
		item.show = item.show + ' (' + item.count + ')'
	})
	dropdown.sort(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		// unshift adds to start of array
		show: state.hdr?.delivery_reliability?.all_companies + ' (' + filteredDropdown.length + ')',
		value: ''
	})
	nc.setArr(state, 'company', dropdown)
	if (rec.selected_company) {
		rec.selected_company = nc.recordArrayField(dropdown, 'value', rec.selected_company, 'show')
		rec.selected_company = ' - ' + peg.parseBefore(rec.selected_company, '- ')
	}
	setProductGroupDropdown(state, data, filteredDropdown)
}

const productGroupAllValue = rec.product_group
function setProductGroupDropdown(state, data, filteredDropdown) {
	if (rec.company) {
		filteredDropdown = data.filter(function (ordr) {
			return ordr.ord.company_id === rec.company
		})
	}
	const productGroupFound = {}
	let item
	const dropdown = filteredDropdown.reduce(function (result, ordr) {
		if (!productGroupFound[ordr.pr.product_group]) {
			item = {
				count: 1,
				show: ordr.pr.product_group,
				value: ordr.pr.product_group
			}
			productGroupFound[ordr.pr.product_group] = item
			result.push(item)
		} else {
			item = productGroupFound[ordr.pr.product_group]
			item.count = item.count + 1
		}
		return result
	}, [])
	const dropdownValueIdx = {}
	dropdown.forEach(function (item) {
		item.show = item.show + ' (' + item.count + ')'
		dropdownValueIdx[item.value] = true
	})
	dropdown.sort(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		// unshift adds to start of array
		show: state.hdr.delivery_reliability.all_companies + ' (' + filteredDropdown.length + ')',
		value: productGroupAllValue
	})
	/*  if (rec.product_group_arr.length > 0) {
		let productGroup = ''
		rec.product_group.forEach(item => {
			if (item !== '--all--') {
				if (productGroup) {
					productGroup += ', ' + nc.recordArrayField(dropdown, 'value', item, 'show')
				} else {
					productGroup += nc.recordArrayField(dropdown, 'value', item, 'show')
				}
			}
		}) */
	if (rec.product_group !== productGroupAllValue) {
		const productGroup = nc.recordArrayField(dropdown, 'value', rec.product_group, 'show')
		rec.selected_company += state.hdr.delivery_reliability.product_group_prefix + peg.parseBefore(productGroup, ' (')
	}
	if (!dropdownValueIdx[rec.product_group]) {
		rec.product_group = productGroupAllValue
	}
	nc.setArr(state, 'product_group', dropdown)
}

function drawChart() {
	// called from layout html
	const rowData = state.grid?.order_row?.data
	if (!rowData) {
		return
	}
	// return
	const data = rec.chart_data
	if (!(data && rec.chart?.reliability)) {
		return
	}
	rec.selected_company = rec.company
	const translate = state.hdr?.delivery_reliability
	if (data.length > 2) {
		data[0].label = translate?.ahead_of_time
		data[1].label = translate?.on_time
		data[data.length - 1].label = translate?.over + ' ' + data[data.length - 1].start
	}
	// const retArr = nc.map(state, rowData, 'day_difference', param) // todo: create nc.map() function
	const chart = rec.chart.reliability
	const warning = []
	const dateFrom = rec.table === 'sales' ? rec.sales_calculate_date : rec.purchase_calculate_date
	let actualDate, targetDate
	const retArr = rowData.map(ordr => {
		ordr.calc = {}
		if (ordr.actual_delivery_date > '1970-01-01') {
			actualDate = ordr.actual_delivery_date
		} else {
			actualDate = ordr.delivery_date
		}
		targetDate = nc.recData(ordr, dateFrom)
		if (targetDate > '1970-01-01') {
			ordr.calc.target_date = targetDate
			ordr.calc.target_date_name = dateFrom.replaceAll('json_data.', ' ').replaceAll('_', ' ')
			ordr.calc.day_difference = dt.dayDifference(targetDate, actualDate)
		} else if (ordr.confirmed_delivery_date > '1970-01-01') {
			ordr.calc.target_date = ordr.confirmed_delivery_date
			ordr.calc.target_date_name = 'confirmed delivery date'
			ordr.calc.day_difference = dt.dayDifference(ordr.confirmed_delivery_date, actualDate)
		} else if (ordr.delivery_date > '1970-01-01') {
			ordr.calc.target_date = ordr.delivery_date
			ordr.calc.target_date_name = 'delivery date'
			ordr.calc.day_difference = dt.dayDifference(ordr.delivery_date, actualDate)
		} else {
			ordr.calc.target_date = actualDate
			ordr.calc.target_date_name = ''
			ordr.calc.day_difference = 0
			if (warning.length < 10) {
				warning.push(
					`Error in order row: ${ordr.order_id}.${ordr.row_number}, delivery date = ${ordr.delivery_date}, actual delivery date = ${ordr.actual_delivery_date}, confirmed delivery date = ${ordr.confirmed_delivery_date}, delivery state = ${ordr.delivery_state}`
				)
			} else if (warning.length === 10) {
				warning.push('...')
			}
		}
		rec.days_late_allowed = parseInt(rec.days_late_allowed) || 0
		if (rec.days_late_allowed !== 0 && ordr.calc.target_date_name === 'delivery date') {
			if (ordr.calc.day_difference - rec.days_late_allowed > 0) {
				ordr.calc.day_difference -= rec.days_late_allowed
			} else {
				ordr.calc.day_difference = 0
			}
		}
		return ordr
	})
	let count = 0
	let max = 10
	let inTimeCount = 0
	let date
	data.forEach(item => {
		item.deliveries = 0
	})
	let filteredData = data.map(function (item) {
		item.deliveries = retArr
			.filter(function (ordr) {
				if (rec.company && ordr.ord.company_id !== rec.company) {
					return false
				} else if (rec.product_group !== productGroupAllValue && ordr.pr.product_group !== rec.product_group) {
					return false
				} /* else if (rec.product_group_arr.length > 0 && !rec.product_group_arr.includes(ordr.pr.product_group)) {
					return false
				} */
				if (rec.query_type !== 'time_period') {
					return true
				}
				date = ordr.calc.target_date // dt.parseDate(ordr.calc.target_date)
				return date >= rec.start_date && date <= rec.end_date
			})
			.reduce(function (sum, ordr) {
				// use nc.arrayStartStopRecord()
				if ((item.start === null || ordr.calc.day_difference > item.start) && (item.stop === null || ordr.calc.day_difference <= item.stop)) {
					item.deliveries = item.deliveries + 1
					count = count + 1
					if (item.stop !== null && item.stop <= 0) {
						inTimeCount = inTimeCount + 1
					}
					sum = sum + 1
					if (item.deliveries > max) {
						max = item.deliveries
					}
				}
				return sum
			}, 0)
		return item
	})
	filteredData = filteredData.map(function (item) {
		item.category = item.label + ' (' + nc.percent(item.deliveries, count) + '%)'
		return item
	})
	rec.number_of_deliveries = count
	rec.delivery_percent = nc.percent(inTimeCount, count)
	rec.graph_warning = warning.join('\n') // default join char is ","
	chart.dataset[0].source = filteredData
	/* if (max > 10) {
		max = Math.round((max + 5) / 5) * 5 // round to next nearest 5
	} */
	chart.yAxis[0].max = max
	chart.yAxis[0].name = translate?.deliveries
	chart.series[0].name = translate?.days_late
	rec.update_chart = rec.update_chart + 1 // update chart
	setDropdown(state, rowData)
	nc.grid.redrawRows(state, 'order_row')
}

pageInit()
