// plugin/go/document-to-text.go
// copied from: https://github.com/sajari/docconv
// copied from: https://github.com/ledongthuc/pdf -- this has problems with pdf text order and \0 in text
// building: see plugin/go/document-to-text.lua

package main

import (
	"C"
	"encoding/json"
	"fmt"

	"code.sajari.com/docconv"
	// prf // /opt/homebrew/Cellar/go/1.18.2/libexec/src/pdf -> /Users/pasi/installed/go/pdf // orig: "github.com/ledongthuc/pdf"
)

func main() {
	fileName := "/Users/pasi/Documents/work/_article/capacic/6 Reasons Why You Shouldn’t Raise Funding. Bootstrap Instead.pdf"
	content := readDocument(fileName) // Read local pdf file
	fmt.Println(content)
	return
}

// * Docconv verison, needs poppler
func readDocument(path string) string {
	/* // Response payload sent back to the requestor
	type Response struct {
		Body  string            `json:"body"`
		Meta  map[string]string `json:"meta"`
		MSecs uint32            `json:"msecs"`
		Error string            `json:"error"`
	} */
	res, err := docconv.ConvertPath(path)
	if err != nil {
		return "err: " + err.Error()
	}
	b, err := json.Marshal(res)
	if err != nil {
		return "err: " + err.Error()
	}
	return string(b)
}

//export readDocumentString
func readDocumentString(path string, buff **C.char) int {
	content := readDocument(path)
	*buff = C.CString(content) // The C string is allocated in the C heap using malloc. It is the caller's responsibility to arrange for it to be freed, such as by calling C.free(*buff).
	return len(content)
}

/*
func readPdf(path string) (string) {
	pdf.DebugOn = true
	f, r, err := pdf.Open(path)
  defer f.Close() // remember to close the file
	if err != nil {
		return "err: " + err.Error()
	}
	var buf bytes.Buffer
	b, err := r.GetPlainText()
	if err != nil {
		return "err: " + err.Error()
	}
	buf.ReadFrom(b)
	return buf.String()
}

func readPdfLine(path string) string {
	pdf.DebugOn = true
	f, r, err := pdf.Open(path)
	defer func() {
		_ = f.Close()
	}()
	if err != nil {
		return "err: " + err.Error()
	}
	var sb strings.Builder
	totalPage := r.NumPage()
	for pageIndex := 1; pageIndex <= totalPage; pageIndex++ {
		p := r.Page(pageIndex)
		if p.V.IsNull() {
			continue
		}
		rows, _ := p.GetTextByRow()
		for _, row := range rows {
		    // println(">>>> row: ", row.Position)
		    for _, word := range row.Content {
		      sb.WriteString(word.S) // fmt.Println(word.S)
		    }
				sb.WriteString("\n")
		}
	}
	return sb.String()
}

//export readPdfString
func readPdfString(path string, buff **C.char) int {
	content := readPdf(path)
	*buff = C.CString(content)
	return len(content)
}

//export readPdfLineString
func readPdfLineString(path string, buff **C.char) int {
	content := readPdfLine(path)
	*buff = C.CString(content)
	return len(content)
} */
