// nc-server/source/javascript/js-beautify-test.js
// test: node --experimental-modules js-beautify-test.js
// https://github.com/beautify-web/js-beautify

import beautifyJs, { defaultOptions } from './js-beautify.js'
const mod = {} // this module functions

const jsonOptions = defaultOptions()
// see: /Users/pasi/ma-git/nc-server/source/.jsbeautifyrc
// todo: copy from ../source/.jsbeautifyrc in Lua side and get as param
jsonOptions.indent_with_tabs = true
jsonOptions.end_with_newline = true
jsonOptions.eol = '\n'
jsonOptions.preserve_newlines = false
jsonOptions.keep_array_indentation = false
jsonOptions.brace_style = 'expand,preserve-inline' // 'expand,preserve-inline'

let testJson = `{
"a": 1.2, "b": ["asd",              6, true, "asd",
		6, true, "asd", 6, true,      "asd", 6,
true, ["asd", 6, true], "asd"]
}`
// testJson = `{ "b": 1, "two": 1, "one"  : 1, "a": 1 }`
mod.beautifyJs = function (jsonTxt) {
	return beautifyJs(jsonTxt, jsonOptions) // JSON.stringify(testJson)
}

let ret = mod.beautifyJs(testJson)
console.log(testJson)
console.log('original => beautified')
console.log(ret)

 
mod // needed for v8 return

/*
console.log(defaultOptions())
{
  raw_options: {},
  disabled: false,
  eol: 'auto',
  end_with_newline: false,
  indent_size: 4,
  indent_char: ' ',
  indent_level: 0,
  preserve_newlines: true,
  max_preserve_newlines: 32786,
  indent_with_tabs: false,
  wrap_line_length: 0,
  indent_empty_lines: false,
  templating: [ 'auto' ],
  brace_preserve_inline: false,
  brace_style: 'collapse',
  unindent_chained_methods: false,
  break_chained_methods: false,
  space_in_paren: false,
  space_in_empty_paren: false,
  jslint_happy: false,
  space_after_anon_function: false,
  space_after_named_function: false,
  keep_array_indentation: false,
  space_before_conditional: true,
  unescape_strings: false,
  e4x: false,
  comma_first: false,
  operator_position: 'before-newline',
  test_output_raw: false
}
*/
