// form/nc/report/nc-report/reclamation/reclamation.js
import nc from '/src/core/nc-util.js'

const recData = nc.recData
export function drawReclamationChart(nc, state, rec, arr, hdr) {
	// called from layout html
	const rowData = state.grid?.report1?.data
	if (!rowData) {
		return
	}
	const data = rec[rec.tab].chart_data
	if (!data) {
		return
	}
	data.forEach(item => {
		item.value = 0
		item.cumulative = 0
	})
	rec.chart = rec[rec.tab].chart
	if (!rec.chart?.option) {
		return
	}
	// rec.start_date = '2020-01-01'
	// const translate = state.hdr?.[rec.tab]
	// const retArr = nc.map(state, rowData, 'day_difference', param) // todo: create nc.map() function
	const chart = rec.chart.option
	const yearData = {}
	const warning = []
	const dateField = 'create_time' // rcl.create_time
	let targetDate, item
	let max = 0
	const retArr = rowData.map(rcl => {
		rcl.calc = {}
		targetDate = recData(rcl, dateField)
		if (targetDate > '1970-01-01') {
			rcl.calc.date = new Date(targetDate)
			rcl.calc.year = rcl.calc.date.getFullYear()
			rcl.calc.month = rcl.calc.date.getMonth() + 1
			if (yearData[rcl.calc.year] == null) {
				yearData[rcl.calc.year] = nc.clone(data) // 12 months
			}
			item = yearData[rcl.calc.year][rcl.calc.month - 1]
			item.value++
			if (item.value > max) {
				max = item.value
			}
		} else {
			if (warning.length < 10) {
				warning.push(`Error in reclamation: ${rcl}`)
			} else if (warning.length === 10) {
				warning.push('...')
			}
		}
		return rcl
	})
	/* let filteredData = data.map(function (item) {
		item.deliveries = retArr
			.filter(function (rcl) {
				return true
				if (rec.company && rcl.ord.company_id !== rec.company) {
					return false
				} else if (rec.product_group !== productGroupAllValue && rcl.pr.product_group !== rec.product_group) {
					return false
				}
				if (rec.query_type !== 'time_period') {
					return true
				}
				date = rcl.calc.date // dt.parseDate(rcl.calc.date)
				return date >= rec.start_date && date <= rec.end_date
			})
			.reduce(function (sum, rcl) {
				// use nc.arrayStartStopRecord()
				if ((item.start === null || rcl.calc.day_difference > item.start) && (item.stop === null || rcl.calc.day_difference <= item.stop)) {
					item.deliveries = item.deliveries + 1
					count = count + 1
					if (item.stop !== null && item.stop <= 0) {
						inTimeCount = inTimeCount + 1
					}
					sum = sum + 1
					if (item.deliveries > max) {
						max = item.deliveries
					}
				}
				return sum
			}, 0)
		return item
	}) */
	/* filteredData = filteredData.map(function (item) {
		item.category = item.label + ' (' + nc.percent(item.deliveries, count) + '%)'
		return item
	}) */
	rec.number_of_deliveries = ''
	rec.delivery_percent = ''
	rec.graph_warning = warning.join('\n') // default join char is ","
	const yearArr = []
	for (const [key, value] of Object.entries(yearData)) {
		yearArr.push({
			year: key,
			data: value
		})
	}
	yearArr.sort((a, b) => a.year - b.year)
	const defaultSerie = nc.clone(chart.series[0])
	chart.series.length = 0
	const defaultDataset = nc.clone(chart.dataset[0])
	chart.dataset.length = 0
	// const defaultTitle = nc.clone(chart.title[0])
	// chart.title.length = 0
	let index = 0
	let title, serie, dataset, year, prevValue
	for (let i = 0; i < yearArr.length; i++) {
		year = yearArr[i]
		prevValue = 0
		year.data.forEach(item => {
			item.cumulative = prevValue + item.value
			prevValue = item.cumulative
		})
		// title = nc.clone(defaultTitle)
		// title.text = year.year
		// chart.title.push(title)
		serie = nc.clone(defaultSerie)
		serie.name = year.year // + ' ' + nc.l('count')
		serie.datasetIndex = index
		serie.yAxisIndex = 0
		chart.series.push(serie)
		dataset = nc.clone(defaultDataset)
		dataset.source = nc.clone(year.data)
		chart.dataset.push(dataset)
		// cumulative line
		index++
		serie = nc.clone(serie)
		serie.type = 'line'
		serie.name = year.year + ' ' + nc.l('cumulative')
		serie.datasetIndex = index
		serie.yAxisIndex = 1
		chart.series.push(serie)
		dataset = nc.clone(dataset)
		dataset.dimensions[1].name = 'cumulative'
		chart.dataset.push(dataset)
		index++
	}
	if (max > 10) {
		max = Math.round((max + 5) / 5) * 5 // round to next nearest 5
	}
	// chart.yAxis[0].max = max
	// chart.yAxis[0].name = translate?.deliveries
	// chart.series[0].name = translate?.days_late

	hdr.report_name = hdr.reclamation.report_name
	hdr.date_type = ''
	hdr.number_of_deliveries = ''
	rec.show_date_row = false
	console.debug(`🚀 ~ drawReclamationChart ~ chart:`, chart)
	return rowData
}
