// form/nc/report/nc-report/nc-report.js
// import { drawChart } from '/plugin/nc-report/delivery-reliability.js'
// import { drawChart } from '/plugin/nc-report/reclamation.js'

function pageInit(ret) {
	const selectionId = nc.searchParameter('id')
	if (selectionId) {
		rec.query_type = 'selection'
		rec.selection_id = selectionId
	} else {
		rec.query_type = 'time_period'
		rec.selection_id = ''
	}
	callServerCallback(ret)
}

// eslint-disable-next-line no-unused-vars
const prevDate = {}
function setPrevDate() {
	prevDate[rec.tab] = { start_date: rec.start_date, end_date: rec.end_date }
}
setPrevDate()
function tabChanged(tab) {
	if (prevDate[tab]) {
		rec.start_date = prevDate[tab].start_date
		rec.end_date = prevDate[tab].end_date
	}
	console.debug(`🚀 ~ tabChanged ~ tab:`, tab)
	callServer()
}

let updateTimeout
function callServerCallback() {
	// rec.query_type = queryType // restore after init call
	// rec.selection_id = selectionId
	rec.query_start_date = rec.start_date // in html, update button as red if out of date range
	rec.query_end_date = rec.end_date
	rec.query_warning = ''
	drawChart() // will call setDropdown(state, data)
	if (updateTimeout) {
		clearTimeout(updateTimeout)
	}
	if (rec.update_seconds > 0) {
		updateTimeout = setTimeout(() => {
			callServer('init')
		}, rec.update_seconds * 1000)
	}
}

function callServer() {
	// queryType = rec.query_type // save now and restore after rest call
	// selectionId = rec.selection_id
	// if (action === 'update') {
	let param = {
		return: {
			grid: [
				{
					name: 'report1',
					tab: rec.tab === 'delivery_reliability' ? rec.table : rec.tab
				}
			]
		}
	}
	if (rec.query_type === 'selection') {
		param.selection_id = rec.selection_id
	} else {
		param.start_date = rec.start_date // dt.dateToString(rec.start_date),
		param.end_date = rec.end_date // dt.dateToString(rec.end_date)
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/report/nc-report/grid.json',
			parameter: param
		},
		callServerCallback
	)
	// }
}

function setDropdown(state, data) {
	let date, item
	const companyFound = {}
	const filteredDropdown = data.filter(function (ordr) {
		// filter out data that is not in selected date range
		if (rec.query_type !== 'time_period') {
			return true
		}
		date = ordr.calc.target_date // nc.parseDate(ordr.calc.target_date)
		return date >= rec.start_date && date <= rec.end_date
	})
	const dropdown = filteredDropdown.reduce(function (result, ordr) {
		if (!companyFound[ordr.ord.company_id]) {
			item = {
				count: 1,
				show: ordr.co.name + ' - ' + ordr.ord.company_id,
				value: ordr.ord.company_id
			}
			companyFound[ordr.ord.company_id] = item
			// if data.find( (element) -> return element.ord.company_id is ordr.ord.company_id )
			result.push(item)
		} else {
			item = companyFound[ordr.ord.company_id]
			item.count = item.count + 1
		}
		return result
	}, [])
	dropdown.forEach(function (item) {
		item.show = item.show + ' (' + item.count + ')'
	})
	dropdown.sort(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		// unshift adds to start of array
		show: state.hdr?.delivery_reliability?.all_companies + ' (' + filteredDropdown.length + ')',
		value: ''
	})
	nc.setArr(state, 'company', dropdown)
	if (rec.selected_company) {
		rec.selected_company = nc.recordArrayField(dropdown, 'value', rec.selected_company, 'show')
		rec.selected_company = ' - ' + peg.parseBefore(rec.selected_company, '- ')
	}
	setProductGroupDropdown(state, data, filteredDropdown)
}

const productGroupAllValue = rec.product_group
function setProductGroupDropdown(state, data, filteredDropdown) {
	if (rec.company) {
		filteredDropdown = data.filter(function (ordr) {
			return ordr.ord.company_id === rec.company
		})
	}
	const productGroupFound = {}
	let item
	const dropdown = filteredDropdown.reduce(function (result, ordr) {
		if (!productGroupFound[ordr.pr.product_group]) {
			item = {
				count: 1,
				show: ordr.pr.product_group,
				value: ordr.pr.product_group
			}
			productGroupFound[ordr.pr.product_group] = item
			result.push(item)
		} else {
			item = productGroupFound[ordr.pr.product_group]
			item.count = item.count + 1
		}
		return result
	}, [])
	const dropdownValueIdx = {}
	dropdown.forEach(function (item) {
		item.show = item.show + ' (' + item.count + ')'
		dropdownValueIdx[item.value] = true
	})
	dropdown.sort(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		// unshift adds to start of array
		show: state.hdr.delivery_reliability.all_companies + ' (' + filteredDropdown.length + ')',
		value: productGroupAllValue
	})
	/*  if (rec.product_group_arr.length > 0) {
		let productGroup = ''
		rec.product_group.forEach(item => {
			if (item !== '--all--') {
				if (productGroup) {
					productGroup += ', ' + nc.recordArrayField(dropdown, 'value', item, 'show')
				} else {
					productGroup += nc.recordArrayField(dropdown, 'value', item, 'show')
				}
			}
		}) */
	if (rec.product_group !== productGroupAllValue) {
		const productGroup = nc.recordArrayField(dropdown, 'value', rec.product_group, 'show')
		rec.selected_company += state.hdr.delivery_reliability.product_group_prefix + peg.parseBefore(productGroup, ' (')
	}
	if (!dropdownValueIdx[rec.product_group]) {
		rec.product_group = productGroupAllValue
	}
	nc.setArr(state, 'product_group', dropdown)
}

function drawChart() {
	// called from layout html
	let url = nc.urlPath()
	if (rec.tab === 'delivery_reliability') {
		url += '/plugin/nc-report/delivery-reliability.js'
	} else if (rec.tab === 'reclamation') {
		url += '/plugin/nc-report/reclamation.js'
	}
	import(/* @vite-ignore */ url)
		.then(module => {
			const rowData = module.drawChart(nc, state, rec, arr, hdr)
			rec.update_chart = rec.update_chart + 1 // update chart
			rowData && setDropdown(state, rowData)
			nc.grid.redrawRows(state, 'report1')
		})
		.catch(err => {
			message.setError(state, `Error loading chart module from url: ${url}, error: ${err}`)
		})
}

pageInit()
