// form/nc/report/nc-report/nc-report.js
// import { drawChart } from '/plugin/nc-report/delivery-reliability.js'
// import { drawChart } from '/plugin/nc-report/reclamation.js'

function pageInit(ret) {
	/* const selectionId = nc.searchParameter('id')
	if (selectionId) {
		rec.query_type = 'selection'
		rec.selection_id = selectionId
	} else { */
	rec.query_type = 'time_period'
	rec.selection_id = ''
	// }
	callServerCallback(ret)
}

const prevDate = {}
function setPrevDate(tab) {
	prevDate[tab || rec.tab] = { start_date: rec.start_date, end_date: rec.end_date }
}
arr.tab.forEach(function (tab) {
	setPrevDate(tab.value)
})
// eslint-disable-next-line no-unused-vars
function changeDate() {
	console.debug(`🚀 ~ changeDate ~ changeDate:`, changeDate)
	setPrevDate()
	drawChart()
}
// eslint-disable-next-line no-unused-vars
function tabChanged(tab) {
	if (prevDate[tab]) {
		rec.start_date = prevDate[tab].start_date
		rec.end_date = prevDate[tab].end_date
	}
	rec.table = rec[rec.tab].table
	console.debug(`🚀 ~ tabChanged ~ tab:`, tab)
	callServer()
}

let updateTimeout
function callServerCallback() {
	// rec.query_type = queryType // restore after init call
	// rec.selection_id = selectionId
	rec.query_start_date = rec.start_date // in html, update button as red if out of date range
	rec.query_end_date = rec.end_date
	rec.query_warning = ''
	drawChart() // will call setDropdown(state, data)
	if (updateTimeout) {
		clearTimeout(updateTimeout)
	}
	if (rec.update_seconds > 0) {
		updateTimeout = setTimeout(() => {
			callServer('init')
		}, rec.update_seconds * 1000)
	}
}

function callServer() {
	// queryType = rec.query_type // save now and restore after rest call
	// selectionId = rec.selection_id
	// if (action === 'update') {
	let param = {
		return: {
			grid: [
				{
					name: 'report1',
					tab: rec.table || rec.tab
				}
			]
		}
	}
	if (rec.query_type === 'selection') {
		param.selection_id = rec.selection_id
	} else {
		param.start_date = rec.start_date // dt.dateToString(rec.start_date),
		param.end_date = rec.end_date // dt.dateToString(rec.end_date)
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/report/nc-report/grid.json',
			parameter: param
		},
		callServerCallback
	)
}

function setDropdown(state, data) {
	let date, arrItem
	const companyFound = {}
	const filteredData = data.filter(function (item) {
		// filter out data that is not in selected date range
		if (rec.query_type !== 'time_period') {
			return true
		}
		date = item.calc.target_date // nc.parseDate(item.calc.target_date)
		return date >= rec.start_date && date <= rec.end_date
	})
	let companyId
	const dropdown = filteredData.reduce(function (result, item) {
		companyId = item.company_id != null ? item.company_id : item.ord.company_id
		if (!companyFound[companyId]) {
			arrItem = {
				count: 1,
				show: item.co.name + ' - ' + companyId,
				value: companyId
			}
			companyFound[companyId] = arrItem
			result.push(arrItem)
		} else {
			arrItem = companyFound[companyId]
			arrItem.count = arrItem.count + 1
		}
		return result
	}, [])
	dropdown.forEach(function (arrItem) {
		arrItem.show = arrItem.show + ' (' + arrItem.count + ')'
	})
	dropdown.sort(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		// unshift adds to start of array
		show: state.hdr?.delivery_reliability?.all_companies + ' (' + filteredData.length + ')',
		value: ''
	})
	nc.setArr(state, 'company', dropdown)
	if (rec.selected_company) {
		rec.selected_company = nc.recordArrayField(dropdown, 'value', rec.selected_company, 'show')
		rec.selected_company = ' - ' + peg.parseBefore(rec.selected_company, '- ')
	}
	return setProductGroupDropdown(state, data, filteredData)
}

const productGroupAllValue = rec.product_group
function setProductGroupDropdown(state, data, filteredData) {
	if (rec.company) {
		let companyId
		filteredData = data.filter(function (item) {
			companyId = item.company_id != null ? item.company_id : item.ord.company_id
			return companyId === rec.company
		})
	}
	const productGroupFound = {}
	let arrItem
	const dropdown = filteredData.reduce(function (result, item) {
		if (!productGroupFound[item.pr.product_group]) {
			arrItem = {
				count: 1,
				show: item.pr.product_group,
				value: item.pr.product_group
			}
			productGroupFound[item.pr.product_group] = arrItem
			result.push(arrItem)
		} else {
			arrItem = productGroupFound[item.pr.product_group]
			arrItem.count = arrItem.count + 1
		}
		return result
	}, [])
	const dropdownValueIdx = {}
	dropdown.forEach(function (arrItem) {
		arrItem.show = arrItem.show + ' (' + arrItem.count + ')'
		dropdownValueIdx[arrItem.value] = true
	})
	dropdown.sort(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		// unshift adds to the start of the array
		show: state.hdr.delivery_reliability.all_companies + ' (' + filteredData.length + ')',
		value: productGroupAllValue
	})
	if (rec.product_group !== productGroupAllValue) {
		const productGroup = nc.recordArrayField(dropdown, 'value', rec.product_group, 'show')
		rec.selected_company += state.hdr.delivery_reliability.product_group_prefix + peg.parseBefore(productGroup, ' (')
		filteredData = filteredData.filter(function (item) {
			return item.pr.product_group === rec.product_group
		})
	}
	if (!dropdownValueIdx[rec.product_group]) {
		rec.product_group = productGroupAllValue
	}
	nc.setArr(state, 'product_group', dropdown)
	return filteredData
}

function drawChart() {
	// also called from layout html
	let url = nc.urlPath()
	if (rec.tab === 'delivery_reliability') {
		url += '/plugin/nc-report/delivery-reliability.js'
	} else if (rec.tab === 'reclamation') {
		url += '/plugin/nc-report/reclamation.js'
	}
	import(/* @vite-ignore */ url)
		.then(module => {
			const rowData = state.grid?.report1?.data
			if (!rowData) {
				return
			}
			module.setRowData(nc, state, rec, arr, hdr, rowData)
			const filteredData = setDropdown(state, rowData)
			module.drawChart(nc, state, rec, arr, hdr, filteredData)
			rec.update_chart = rec.update_chart + 1 // update chart
			nc.grid.redrawRows(state, 'report1')
		})
		.catch(err => {
			message.setError(state, `Error loading chart module from url: ${url}, error: ${err}`)
		})
}

pageInit()
