// form/nc/report/nc-report/reclamation/reclamation.js

export function setRowData(nc, state, rec, arr, hdr, rowData) {
	const dt = nc.dt
	const recData = nc.recData
	const dateField = 'create_time' // rcl.create_time
	const nullDate = dt.parseDate('1970-01-01')
	let date
	rowData.map(rcl => {
		// calculate dates to all data
		rcl.calc = {}
		date = recData(rcl, dateField)
		if (date > '1970-01-01') {
			rcl.calc.target_date = date
			rcl.calc.date = new Date(date)
			rcl.calc.year = rcl.calc.date.getFullYear()
			rcl.calc.month = rcl.calc.date.getMonth() + 1
		} else {
			rcl.calc.target_date = '1970-01-01'
			rcl.calc.date = new Date(nullDate.getTime())
			rcl.calc.year = rcl.calc.date.getFullYear()
			rcl.calc.month = rcl.calc.date.getMonth() + 1
		}
		return rcl
	})
}

export function drawChart(nc, state, rec, arr, hdr, rowData) {
	const dt = nc.dt
	const data = rec[rec.tab].chart_data
	if (!data) {
		return
	}
	data.forEach(item => {
		item.value = 0
		item.cumulative = 0
	})
	rec.chart = rec[rec.tab].chart
	if (!rec.chart?.option) {
		return
	}
	const yearData = {}
	const warning = []
	const nullDate = dt.parseDate('1970-01-01')
	const orderRow = state.grid.report2?.data
	console.debug(`🚀 ~ drawChart ~ orderRow:`, orderRow)
	let item
	rowData.map(rcl => {
		// calculate values from filtered data
		// todo: reclamation percentage and value data calculations here
		if (rcl.calc.date > nullDate) {
			if (yearData[rcl.calc.year] == null) {
				yearData[rcl.calc.year] = nc.clone(data) // 12 months
			}
			item = yearData[rcl.calc.year][rcl.calc.month - 1]
			item.value++ // for count value, change for  reclamation percentage and value data calculations here
		} else {
			if (warning.length < 10) {
				warning.push(`Error in reclamation: ${rcl}`)
			} else if (warning.length === 10) {
				warning.push('...')
			}
		}
		return rcl
	})
	rec.number_of_deliveries = '' // clean subheaders
	rec.delivery_percent = ''
	rec.graph_warning = warning.join('\n') // default join char is ","
	const yearArr = []
	for (const [key, value] of Object.entries(yearData)) {
		yearArr.push({
			year: key,
			data: value
		})
	}
	yearArr.sort((a, b) => a.year - b.year)
	const chart = nc.clone(rec.chart.option)
	const defaultSerie = nc.clone(chart.series[0])
	chart.series.length = 0
	const defaultDataset = nc.clone(chart.dataset[0])
	chart.dataset.length = 0
	let index = 0
	let serie, dataset, year, prevValue
	for (let i = 0; i < yearArr.length; i++) {
		year = yearArr[i]
		prevValue = 0
		year.data.forEach(item => {
			item.cumulative = prevValue + item.value
			prevValue = item.cumulative
		})
		// count bar
		serie = nc.clone(defaultSerie)
		serie.name = year.year // + ' ' + nc.l('count')
		serie.datasetIndex = index
		serie.yAxisIndex = 0
		chart.series.push(serie)
		dataset = nc.clone(defaultDataset)
		dataset.source = nc.clone(year.data)
		chart.dataset.push(dataset)
		// cumulative line
		index++
		serie = nc.clone(serie)
		serie.type = 'line'
		serie.name = year.year + ' ' // can't be same as count, so add ' '  - or nc.l('cumulative')
		serie.datasetIndex = index
		serie.yAxisIndex = 1
		chart.series.push(serie)
		dataset = nc.clone(dataset)
		dataset.dimensions[1].name = 'cumulative'
		chart.dataset.push(dataset)
		index++
	}
	hdr.report_name = hdr.reclamation.report_name
	hdr.date_type = ''
	hdr.number_of_deliveries = ''
	rec.show_date_row = false
	rec.chart.option = chart
	console.debug(`🚀 ~ drawReclamationChart ~ chart:`, chart)
	return rowData
}
