// form/nc/report/nc-report/delivery-reliability/delivery-reliability.js

export function setRowData(nc, state, rec, arr, hdr, rowData) {
	rec.show_date_row = true
	rec.show_grid2 = false
	const recData = nc.recData
	const dayDifference = nc.dt.dayDifference
	// const productGroupAllValue = rec.product_group
	// called from layout html
	// const retArr = nc.map(state, rowData, 'day_difference', param) // todo: create nc.map() function
	const dateFrom = rec.table === 'sales' ? rec.sales_calculate_date : rec.purchase_calculate_date
	const arrName = rec.table === 'sales' ? 'sales_calculate_date' : 'purchase_calculate_date'
	const arrItem = nc.recordArrayRecord(arr[arrName], 'value', dateFrom)
	hdr.delivery_reliability.used_delivery_date = arrItem?.show || 'unknown date'
	let targetDateName
	if (arrItem && arrItem.show2) {
		targetDateName = arrItem.show2
	}
	const compareDateFrom = rec.table === 'sales' ? rec.sales_compare_date : rec.purchase_compare_date
	const compareArrName = rec.table === 'sales' ? 'sales_calculate_date' : 'purchase_calculate_date'
	const compareArrItem = nc.recordArrayRecord(arr[compareArrName], 'value', compareDateFrom)
	hdr.delivery_reliability.used_compare_date = compareArrItem?.show || 'unknown date'
	let compareDateName
	if (compareArrItem && compareArrItem.show2) {
		compareDateName = compareArrItem.show2
	}
	const warning = []
	let actualDate, targetDate
	rowData.map(ordr => {
		ordr.calc = {}
		actualDate = recData(ordr, compareDateFrom)
		ordr.calc.compare_date_name = compareDateName || compareDateFrom.replaceAll('json_data.', ' ').replaceAll('_', ' ')
		if (actualDate <= '1970-01-01') {
			if (ordr.actual_delivery_date <= '1970-01-01') {
				actualDate = ordr.delivery_date
				ordr.calc.compare_date_name = 'delivery date'
			} else {
				actualDate = ordr.actual_delivery_date
				ordr.calc.compare_date_name = 'actual delivery date'
			}
		}
		ordr.calc.compare_date = targetDate
		targetDate = recData(ordr, dateFrom)
		if (targetDate > '1970-01-01') {
			ordr.calc.target_date = targetDate
			ordr.calc.target_date_name = targetDateName || dateFrom.replaceAll('json_data.', ' ').replaceAll('_', ' ')
			ordr.calc.day_difference = dayDifference(targetDate, actualDate)
		} else if (ordr.confirmed_delivery_date > '1970-01-01') {
			ordr.calc.target_date = ordr.confirmed_delivery_date
			ordr.calc.target_date_name = 'confirmed delivery date'
			ordr.calc.day_difference = dayDifference(ordr.confirmed_delivery_date, actualDate)
		} else if (ordr.delivery_date > '1970-01-01') {
			ordr.calc.target_date = ordr.delivery_date
			ordr.calc.target_date_name = 'delivery date'
			ordr.calc.day_difference = dayDifference(ordr.delivery_date, actualDate)
		} else {
			ordr.calc.target_date = actualDate
			ordr.calc.target_date_name = ''
			ordr.calc.day_difference = 0
			if (warning.length < 10) {
				warning.push(
					`Error in order row: ${ordr.order_id}.${ordr.row_number}, delivery date = ${ordr.delivery_date}, actual delivery date = ${ordr.actual_delivery_date}, confirmed delivery date = ${ordr.confirmed_delivery_date}, delivery state = ${ordr.delivery_state}`
				)
			} else if (warning.length === 10) {
				warning.push('...')
			}
		}
		rec.days_late_allowed = parseInt(rec.days_late_allowed) || 0
		if (rec.days_late_allowed !== 0) {
			// && ordr.calc.target_date_name === 'delivery date'
			if (ordr.calc.day_difference - rec.days_late_allowed > 0) {
				ordr.calc.day_difference -= rec.days_late_allowed
			} else {
				ordr.calc.day_difference = 0
			}
		}
		return ordr
	})
	rec.graph_warning = warning.join('\n') // default join char is ","
}

export function drawChart(nc, state, rec, arr, hdr, rowData) {
	let count = 0
	let max = 10
	let inTimeCount = 0
	// let date
	const data = rec[rec.tab].chart_data
	if (!data) {
		return
	}
	data.forEach(item => {
		item.deliveries = 0
	})
	rec.chart = rec[rec.tab].chart
	if (!rec.chart?.option) {
		return
	}
	const translate = state.hdr?.[rec.tab]
	data[0].label = translate?.ahead_of_time
	data[1].label = translate?.on_time
	const chart = rec.chart.option
	data[data.length - 1].label = translate?.over + ' ' + data[data.length - 1].start
	let filteredData = data.map(function (item) {
		item.deliveries = rowData.reduce(function (sum, ordr) {
			// use nc.arrayStartStopRecord()
			if ((item.start === null || ordr.calc.day_difference > item.start) && (item.stop === null || ordr.calc.day_difference <= item.stop)) {
				item.deliveries = item.deliveries + 1
				count = count + 1
				if (item.stop !== null && item.stop <= 0) {
					inTimeCount = inTimeCount + 1
				}
				sum = sum + 1
				if (item.deliveries > max) {
					max = item.deliveries
				}
			}
			return sum
		}, 0)
		return item
	})
	filteredData = filteredData.map(function (item) {
		item.category = item.label + ' (' + nc.percent(item.deliveries, count) + '%)'
		return item
	})
	rec.number_of_deliveries = count
	rec.delivery_percent = nc.percent(inTimeCount, count)
	chart.dataset[0].source = filteredData
	/* if (max > 10) {
		max = Math.round((max + 5) / 5) * 5 // round to next nearest 5
	} */
	chart.yAxis[0].max = max
	chart.yAxis[0].name = translate?.deliveries
	chart.series[0].name = translate?.days_late
	// headers
	hdr.report_name = rec.table === 'sales' ? hdr.delivery_reliability.sales_delivery_reliability : hdr.delivery_reliability.purchase_delivery_reliability
	hdr.date_type = hdr.delivery_reliability?.used_delivery_date + ' / ' + hdr.delivery_reliability?.used_compare_date
	rec.selected_company = rec.company ? nc.recordArrayField(arr.company, 'value', rec.company, 'show') : ''
	rec.selected_company = nc.peg.parseBefore(rec.selected_company, ' (')
	hdr.number_of_deliveries =
		hdr.delivery_reliability.number_of_deliveries +
		': ' +
		rec.number_of_deliveries +
		', ' +
		hdr.delivery_reliability.delivery_reliability_percent +
		': ' +
		rec.delivery_percent +
		'%' +
		(rec.selected_company ? ' - ' + rec.selected_company : '')
	return rowData
}
