let translateInUse = localStorage.nc_translateInUse || 0
let translateActive = translateInUse > 0
let translateNotActive = !translateActive

function setTranslateMode() {
	translateNotActive = !translateActive
	// click to checkbox returns previous value before click
	if (translateActive) {
		return (localStorage.nc_translateInUse = 1)
	} else {
		return (localStorage.nc_translateInUse = 0)
	}
}

function translatableDirective(name, template, styleClass) {
	var translationTemplate
	translationTemplate =
		'<input type="text" ng-show="translateInUse" ng-model="labelText" ng-change="changeText()" class="nc-translate" ng-class="{changed: !textIsSame}" context-menu="menuOptions"/>'
	return app.directive(name, [
		'lang',
		'nc',
		function (lang, nc) {
			return {
				require: '?^ngModel',
				restrict: 'E',
				replace: true,
				transclude: true,
				template: '<span>' + translationTemplate + '<span ng-show="!translateInUse">' + template + '</span></span>',
				scope: {
					labelText: '=ngModel'
				},
				link: function (state, element, attrs, ngModel) {
					var getMenuOptions, hdrId, justTransclude, mainScope, originalText
					state.styleClass = styleClass
					state.textIsSame = true
					state.translateInUse = lang.translateInUse()
					mainScope = nc.mainScope()
					hdrId = null
					if (attrs.ngModel) {
						hdrId = attrs.ngModel.split('.').slice(1).join('.')
					}
					if (!hdrId) {
						console.warn(name + ' is missing proper hdr id!')
					}
					getMenuOptions = function () {
						return [ngModel.$modelValue].concat(lang.getAlternatives(hdrId)).map(function (v) {
							return [
								v,
								function (name) {
									var textIsSame
									ngModel.$setViewValue(name)
									textIsSame = state.labelText === name
									state.textIsSame = textIsSame
									return (mainScope.hdrChanged[hdrId] = !textIsSame)
								}
							]
						})
					}
					originalText = ''
					justTransclude = false
					mainScope.$watch(
						'translate.use',
						function (translateInUse) {
							var transclusionElement, transclusionText
							state.translateInUse = translateInUse
							if (translateInUse) {
								state.menuOptions = getMenuOptions()
								if (!ngModel.$modelValue) {
									transclusionElement = element.find('.transclusion')
									if (transclusionElement.length) {
										transclusionText = transclusionElement[0].textContent
										ngModel.$setViewValue(transclusionText)
										justTransclude = true
									}
								}
								state.textIsSame = true
								return (originalText = ngModel.$modelValue)
							} else if (justTransclude && state.textIsSame) {
								return ngModel.$setViewValue(transclusionText)
							}
						},
						true
					)
					return (state.changeText = function () {
						var textIsSame
						textIsSame = state.labelText === originalText
						state.textIsSame = textIsSame
						return (mainScope.hdrChanged[hdrId] = !textIsSame)
					})
				}
			}
		}
	])
}

/* execute possible init for state. note that the deps are fixed!
- file is not loaded yet, this does not work

*/
// ------------------- main, load data -------------------
// loadInputData()
/*
Kaivetaan html:stä lista kaikkien selectien ng-modeleista
lähetä lista parametrinä rest-kutsulle popup nimisessä parametrissä
*/
// selectNgModel = jQuery("select").map ->
//   this.getAttribute("ng-model")
// console.log("selectNgModel", selectNgModel)
/*
googleTranslate = () ->
  newScript = document.createElement("script")
  newScript.type = "text/javascript"
  sourceText = escape(document.getElementById("sourceText").innerHTML)
 * WARNING: be aware that YOUR-API-KEY inside html is viewable by all your users.
 * Restrict your key to designated domains or use a proxy to hide your key
 * to avoid misuage by other party.
  source = "https://www.googleapis.com/language/translate/v2?key=YOUR-API-KEY&source=en&target=de&callback=translateText&q=" + sourceText
  newScript.src = source
 * When we add this script to the head, the request is sent off.
  document.getElementsByTagName("head")[0].appendChild newScript
 */
