// nc-input/nc-label.js

// /src/components/nc-input/nc-label.vue
// import createComponent from './nc-form-col-row.js'

import createComponent from './nc-translate.js'
export default { render: render, ...createComponent('NcLabel', false) } // true == set default width:100%;

// render code
import {
	toDisplayString as _toDisplayString,
	createTextVNode as _createTextVNode,
	Fragment as _Fragment,
	openBlock as _openBlock,
	createElementBlock as _createElementBlock,
	createCommentVNode as _createCommentVNode,
	renderSlot as _renderSlot,
	normalizeStyle as _normalizeStyle
} from '../../vuelib.js'

export function render(_ctx, _cache) {
	return (
		_openBlock(),
		_createElementBlock(
			'label',
			{
				class: 'nc-label',
				style: _normalizeStyle(_ctx.labelStyle)
			},
			[
				_ctx.langLabel
					? (_openBlock(), _createElementBlock(_Fragment, { key: 0 }, [_createTextVNode(_toDisplayString(_ctx.langLabel), 1 /* TEXT */)], 64 /* STABLE_FRAGMENT */))
					: _renderSlot(_ctx.$slots, 'default', { key: 1 })
			],
			4 /* STYLE */
		)
	)
}
