
# Product Entity Relationship Diagram

```mermaid
erDiagram
    product {
        varchar(80) product_id PK
        varchar(200) name
        varchar(40) work_number_id
        varchar(80) drawing_number
        varchar(20) stock_unit
        varchar(20) design_unit
        double unit_multiplier
        varchar(80) ean_code
        text info
        varchar(40) product_group
        varchar(40) subgroup
        varchar(40) quality
        integer product_state
        integer product_type
        integer stock_type
        integer production_type
        double purchase_price
        double purchase_multiplier
        double cost_price
        double profit_multiplier
        double sales_price
        varchar(40) default_supplier_id FK
        varchar(40) purchase_order_code_id FK
        varchar(40) sales_order_code_id FK
        double minimum_order_amount
        double minimum_stock
        double setup_time
        double calculation_lot
        text json_data
    }

    additional_field {
        varchar(80) header
        text value
    }

    company {
        varchar(40) company_id PK
    }

    order_code {
        varchar(40) order_code_id PK
    }

    product ||--o{ additional_field : contains
    product }o--|| company : default_supplier_id
    product }o--|| order_code : purchase_order_code_id
    product }o--|| order_code : sales_order_code_id
    product }o--|| order_code : foreign_sales_order_code_id
    product }o--|| company : default_customer_id

```
