# Lantek SQL views

## List of used Nestix tables

1. `nxmat` - materials
1. `nxorderpos`
1. `nxsheet`
1. `nxsheetpath`
1. `nxsheetpathdet`

### List of Nestix fields that are used in Manageri ERP

**These tables and fields should be created as SQL views in the Lantek database**. See later the SELECT statements on how these fields are used in Manageri ERP.

```txt
nxmat.nxmatid - integer, char in Manageri
nxmat.nxthickness - float
not in use:
  nxmat.nxprice - float
  nxmat.nxquality - char, material quality like S355J2G3

nxorderpos.nxmatid - integer
nxorderpos.nxorderposid - integer
nxorderpos.nxcustmark - char
not in use:
  nxorderpos.nxdetailid - integer
  nxorderpos.nxworknmb - char

nxsheet.nxsheetid - integer
nxsheet.nxname - char
nxsheet.nxmatid - integer, char in Manageri
not in use:
  nxsheet.nxfreeweight - float
  nxsheet.nxisremnant - integer

nxsheetpath.nxsheetid - integer
nxsheetpath.nxsheetpathid - integer
not in use:
  nxsheetpath.nxpathid - integer

nxsheetpathdet.nxsheetpathid - integer
nxsheetpathdet.nxorderposid - integer
nxsheetpathdet.nxarea - float
nxsheetpathdet.nxdetailcount - integer
nxsheetpathdet.nxspdmachtime - float
nxsheetpathdet.nxusedarea - float
nxsheetpathdet.nxweight - float
```

## Starting a cutting program in Manageri ERP

### Setting plate ID number before starting the work

![Work start](nestix-pict/work-start.png)

When the user enters `74102-1` into the field `Ohjelman numero` (Nestix program number) in the picture above, the following SQL queries (simplified in this document) are executed:

```sql
SELECT nxmatid, nxsheetid FROM nxsheet WHERE (nxsheet.nxname='74102-1') -- returns nxmatid 239 and nxsheetid 153248
SELECT nxthickness FROM nxmat WHERE (nxmat.nxmatid=239)
SELECT nxsheetpathid FROM nxsheetpath WHERE (nxsheetpath.nxsheetid='153248') -- returns nxsheetpathid 167568
SELECT nxorderposid,nxspdmachtime,nxdetailcount,nxusedarea,nxarea,nxweight FROM nxsheetpathdet WHERE (nxsheetpathdet.nxsheetpathid=167568) -- returns nxorderposid: 747279,749869,750481,751072,751079,751366
SELECT nxorderposid,nxcustmark FROM nxorderpos WHERE nxorderpos.nxorderposid IN (747279,749869,750481,751072,751079,751366)
```

```txt
Finnish: Työvaiheiden massakuittaus, ohjelmanumeron asettaminen.

työpisteen massa-aloitus:

* manageri kysyy ajo-ohjelman nimen ja työntekijä syöttää
sen, esim: 000000011
* manageri etsii nestixin nxpath taulusta nxname perusteella ajo-ohjelman
-> saadaan nxpathid

* etsitään nxsheetpath taulusta nxpathid perusteella
-> saadaan nxsheetpathid

* etsitään nxsheetpathdet taulusta nxsheetpathid
-> löytyy monta josta saadaan taulukkoon talteen nxorderposid,
-> nxspdmachtime (yksikköajoajat) sekä
- > nxdetailcount ( aloitetut kappaleet eli monta syntyy levystä)

* etsitään nxorderpos taulusta nxorderposid:t
-> löytyy monta josta saadaan taulukkoon talteen nxworknmb
joka on mg valmistuserä

nxworknmb sisältää kaikki managerin valmistuserien numerot (työmääräimet)

näiden perustella etsitään valmistuserät ja täytetään massa-aloitusikkunaan kaikki työt, aloitetaan työt

manageriin palautetaan mat. paksuus + laatu XXX? logiikalla (Tero selvittää)

AK: 2008-11-09:
nxorderpos.nxmatid -kentän perusteella etsitään materiaalit nxmat-taulusta:
nxmat.nxmatid = nxorderpos.nxmatid löytyneestä nxmatid tietueesta luetaan nxmat.nxquality ja nxmat.nxthickness (laatu ja paksuus). $4-parametrimuuttujaan palautetaan teksti: "laatu/paksuus"
```

## Ending a cutting program in Manageri ERP

### Setting program id number

![Work stop](nestix-pict/work-stop.png)

When the user enters `74102-1` into the field `Ohjelman numero` (Nestix program number) in the picture above, the following SQL queries are executed:

```sql
SELECT nxmatid, nxsheetid FROM nxsheet WHERE (nxsheet.nxname='74102-1') -- returns nxmatid 239 and nxsheetid 153248
SELECT nxthickness FROM nxmat WHERE (nxmat.nxmatid=239)
SELECT nxsheetpathid FROM nxsheetpath WHERE (nxsheetpath.nxsheetid='153248') -- returns nxsheetpathid 167568
SELECT nxorderposid,nxspdmachtime,nxdetailcount,nxusedarea,nxarea,nxweight FROM nxsheetpathdet WHERE (nxsheetpathdet.nxsheetpathid=167568)) -- returns nxorderposid: 747279,749869,750481,751072,751079,751366
SELECT nxorderposid,nxcustmark FROM nxorderpos WHERE nxorderpos.nxorderposid IN (747279,749869,750481,751072,751079,751366)
```

```txt
Finnish: Työvaiheiden massakuittaus lopetus:

etsinnät kuten aloituksessa
* kyseiselle levylle sijoiteltejen työnumeron kappalemäärät
luetaan nxsheetpathdet.nxdetailcount -kentästä
* työajat/kpl luetaan nxsheetpathdet.nxspdmachtime kentästä

noiden kenttien mukaan manageri jyvittää managerin aloitus/lopetuskuittauksen kuluneen ajan ja tekee toteutuneet määrät ja työtulokset
```

---

## Info in Finnish

```txt

keräilylistaan tiettyyn piirustusnumeroon liittyvät kuvat:

nxdetail.drawing = piirustusnumero
nxdetail.nxprmeta kentässä on esikatselukuvan (verrkkolevyn polku)
nimi joka aukeaa suoraan windowsissa
 - tämä kuva tulostetaan keräilylistaan 2-3 postimerkin kokoisena

------------------

Kun nestix:ssä tehdään sijoittelu, levy saa nimen. Tässä esimerkkejä levyn nimistä ja palojen nimeämisetä:

sijoittelu yhdelle levylle:
levyn nimi on 20585
levyn paloja:
20585-1
20585-2
20585-5-1
20585-1-1-1-1-1
20585-8-1-2-1-1

Esim. 20585-levyn 5. jättöpalasta on jaanut pala: 20585-5-1

monilevysijoittelu:
levyn nimi on 20585-01
levyn paloja:
20585-01-1
20585-01-2

muiden levyjen paloja:
20585-02-1
20585-09-1-1
20585-25-2-1-2-1

HUOM. 20585-10 tarkoittaa monilevysijoittelun 10. levyä - ei yhden levyn 10. palaa

```

---

## Set up SQL trace in Manageri

1. mene .Asetus -tauluun ja monista asetus `_db_id_Nestix` -nimelle `_db_id_NestixLantek`
2. lisää asetukseen _db_id_NestixLantek tekstiarvoon rivi: `<SqlTraceOn>1</SqlTraceOn>`
3. avaa asetus <>c_nestix_tDatabaseId
   - laita tektiarvo kenttään _db_id_NestixLantek
   - paina Aseta arvo nappia
   - kumoa asetuksen muutos jotta tämä ei tule muille voimaan kuin sinulle
4. Poista trace päältä kun olet saanut tarvittavat tiedot
   - avaa asetus <>c_nestix_tDatabaseId
   - laita tektiarvo kenttään _db_id_Nestix
   - paina Aseta arvo nappia
   - sulje asetus, asetusta ei tarvitse tallentaa
