# Binary Search Progress Display Manual

## Overview

The binary search feature in db-sync provides real-time progress feedback when searching for records to synchronize. This manual explains how to read and understand the progress output.

## Basic Format

```text
delete binary search 179196 records, search 5000 recent first, need to find 2:
2.8%↑5000 97%↓174197 49%↑87097 24%↑43547 12%↓21775 6.1%↑10886 3.0%↑5442 1.5%↓2722 0.8%↓1362 0.4%↓682 0.2%↓342
```

## Understanding the Output

### Initial Line

- **179196 records**: Total number of records to search through
- **search 5000 recent first**: Will prioritize the most recent 5000 records
- **need to find 2**: Target number of records to locate

### Progress Indicators

Each progress indicator shows: `percentage + direction + count`

#### Percentage

- **≥10%**: Shows whole numbers (e.g., `24%`, `49%`)
- **<10%**: Shows one decimal place (e.g., `2.8%`, `6.1%`, `0.4%`)
- Represents what portion of the total dataset this range covers

#### Direction Arrows

- **↑ (up arrow)**: Searching upper portion (newer/recent records)
- **↓ (down arrow)**: Searching lower portion (older records)

#### Count

- Exact number of records in this search range
- For "recent first", the first range will always show the configured recent count (e.g., 5000)

## Search Strategy

### Recent First Logic

1. **First search**: `2.8%↑5000` - Searches the most recent 5000 records from the source
2. **Remaining search**: `97%↓174197` - Searches the remaining older records from the source
3. **Subdivisions**: Each large range is split in half recursively

### Binary Division

The algorithm uses binary search to efficiently narrow down ranges:

- Large ranges (>500 records) are split in half
- Small ranges (≤500 records) are processed directly
- Each split shows both halves with their respective percentages

## Reading Examples

### Example 1: Recent First Search

```text
2.8%↑5000 97%↓174197
```

- Search 5000 recent records from the source (2.8% of total)
- Then search remaining 174,197 older records from the source (97% of total)

### Example 2: Binary Subdivision

```text
49%↑87097 24%↑43547
```

- Split a range into upper half (49% of total, 87,097 records from the source)
- And lower half (24% of total, 43,547 records from the source)

### Example 3: Final Small Batches

```text
0.8%↓1362 0.4%↓682 0.2%↓342
```

- Processing small batches directly from the source
- Shows precise decimal percentages for granular progress

## Final Results

```text
read 342 found 1 - total 2/2.
```

- **read 342**: Processed 342 records in final batch
- **found 1**: Located 1 target record in this batch
- **total 2/2**: Found all 2 required records

## Summary Statistics

```text
delete binary search count 1: 00:00:12 (16 iterations, 46 queries, depth 10, found 2 records to delete, recent first 5000, batch size 500)
```

- **00:00:12**: Total time taken
- **16 iterations**: Number of search iterations
- **46 queries**: Database queries executed
- **depth 10**: Maximum search tree depth
- **found 2 records**: Final result count
- **batch size 500**: Records processed per final batch

## Configuration

### Recent First Setting

- Configured via `binary_search_recent_first` preference
- Typical values: 1000, 5000, 10000
- Set to 0 to disable recent-first behavior

### Batch Size

- Determines when to stop subdividing and process directly
- Default: 500 records
- Smaller values = more granular progress, more queries
- Larger values = less granular progress, fewer queries

## Benefits

1. **Real-time feedback**: See search progress as it happens
2. **Performance insight**: Understand where time is spent
3. **Debugging aid**: Identify slow search ranges
4. **User confidence**: Visual confirmation that sync is progressing

---

*This progress display helps users understand and monitor the binary search process during database synchronization operations.*
