# Db-sync.lua & db-sync.json

- käynnistys komento: `lj db-sync.lua`
- jos `sync_all` on false käytetään `sync_table`
- `db-sync.json`, rivit 24 alkaen ovat arvoja, jotka määrittelevät mitä ja miten synkataan.
- `sync_all`, false -> sync_table arvoilla voidaan muuttaa mitä halutaan synkata. sync_table synkkaa vain tiettyjä.
- `sync_table_query`, erp-sync on mm. vastuussa synkkaamaan kahden erp-järjestelmän välillä halutut tiedot, jotka sisälletään `sync_table_query`.
- `sync_table_method`, sisältää tiedot mitä tietoja
- `sync-table`, sisältää tiedon mitkä tablet synkataan.
- `no-sync-table`, sisältää tiedon mitkä tablet ei synkata.
- `-` miinus merkki attributen lopussa tarkoittaa, ettei asetus ole päällä.
- sisältää myös property-arvoja, joiden avulla määritellään kuinka moneen järjestelmään synkataan mm. `db_target_id`

etsintöjen tulojen summa esitetään kerran, työvaiheet siirretään

## Db-sync.lua

- Ensin on check-vaihe, jossa tarkastetaan synkattavien tietuetten määrää.
- `upperLevelPreference` -> haetaan levyltä, jollei löydä -> tietokanta, jollei löydy -> default
- `tableIterator` -> looppaa `source_id` sitten `target_id`, to pyydetään inner loopiksi.
- taulu array loopataan katsotaan mitä pitäisi ja ei pitäisi synkata.
- Kun "loop all" on päällä ei katsotaan mitä pitäisi synkata.
- sync_table -> katsotaan onko listalla
- tietokanta yhteys, `source_id`:sta -> katsotaan löytyykö table `tableExists()`
- `checkDatabase()` verrataan json kohdetietokantaan, jollei täsmää muokataan SQL kyselyllä JSON:n muotoon.
- generic show, debug sql funktiot ja tarvittaessa `connectionChange`.
- `sleep_seconds` suurempi kuin nolla, joka käynnistää syncin tietyin väliajoin.
- `checkSyncTable()`
- query_name, `default_query.json` käytetään jos json:ssa ei ole määritelty
- `table_name-record_type` -> esim. `resource-load_group`
- `modifyTimeFieldExt` (capacic) ja `modifyTimeField` (4D), käytetään record_key jollei löydy.
- `syncRec` -> synkattavan tiedon tiedot, jota pidetään mukana.
- tehdään tietokanta pyyntö
- sourceCountAll
- `targetConnTbl`
- `targetCountAll` muuttuja
- muutos id kenttä (vain 4D), unique ID, (postgre uuid)
- etsitään muutos id vanhasta, tuotteita ei lisätty eikä poistettu, jollei määrät täsmää -> verrataan tietueita mitä on lisätty tai poistettu.
- isoin muutos id etsitään -> (`target_id`) kohde taulusta etsitään suurin -> prevModifyId -> sqlite:ssä etsitään suurin time modify kenttä.
- etsitään lähdetaulusta ne tietuet, käyttäen `runQuery()`.
- modifyId etsitään -> parametrien avulla tietokannasta, muutos id, joka on suurempi kuin viimeisin muutos id.
- haetaan ne mitkä on muuttunut edellisen syncin jälkeen.
- `tableIterator`, annetaan callback `checkSyncTable`, jos palauttaa false:n niin if-statement:n return palauttaa nil arvon
- records synced: paljonko on synkattu
- `copyLoop()` -> `copyData()` -> `copyCallback`
- taulun kentät luetaan
- batchSize eli synkataan tietty määrä kerrallaan
- muutos_id/modify_id -> sync rec
- `full_compare` -> 0, tarkoittaa ettei se ole päällä. Vertaa kaikki modify_id:t.
- virhe, kun alkaa synkata tietueita mitä siellä on jo.
- bugin aiheutti `syncRec.alwaysInsert = true`

```lua
qryRet = runQuery(queryName, syncRec, param, prevSyncModifyId) -- rivi 1132
```

- `moveData(qryRet.data)` annetaan runQueryStä tulevat tietuet, mikä näkyy riivllä 1132.
- `max_error_count` -> kuinka monta erroria saa tapahtua ennen kuin ohjelma lopettaa synkkaamisen. 4D ja Postgre:ssa voi esiintyä virheitä arvoista joita ei ole määritetty, jotka voidaan tällä ylittää, jotta ohjelma on mahdollista ajaa production ympäristössä ongelmitta.

## vanha logiikkaongelma

- vanha logiikka ongelma, ei tiedetty milloin oli tuhottu

## Muut

- sen sijaan, että tehdään tietyin väliajoin synkkejä, pitäisi tehdä UDP:n periaatteella (ilman, että kadottaa paketteja) eli live synkkejä, joka puolestaan ei rasita erp-järjestelmää yhtäpaljon.
- `dprf.prf` pistää välimuistiin

## TODO

- 4D tuhoamisen ruutu pitää tuoda web-versioon
