# DB-sync työkalu

DB-sync on työkalu kokonaisuus, jolla voidaan synkronoida Capacic-järjestelmän tietokanta ulkoisesta päätepisteestä. Työkalu koostuu `db-sync.lua`-skriptistä ja `db-sync.json`-tiedostosta, joista lua-skripti sisältää itse toiminnon logiikan ja JSON-tiedosto sisältää tiedot, miten synkronoiminen pitäisi tehdä ja mitä synkronoidaan.

JSON-tiedostossa sisältää monia arvoja, joista suurin osa on synkronisoitavia arvoja, jotka sisällytetään joko listan tai objektin sisään. Synkronoitavat arvot ovat sijoitettu JSON-tiedoston loppupuolelle ja tiedoston alku on omistettu asetusarvoille, joilla voidaan muokata työkalun toiminnallisuuksia. Synkronoimisen etsintöjen tulojen summa esitellään kerran ja työvaiheet siirretään.

- `info`-arvon avulla voidaan määritellä mm. kuinka laaja synkroni tehdään.
- `sync_all` määrittelee synkronoidaanko kaikki arvot, mikäli arvo on määritelty `false`-arvoksi tullaan käyttämään `sync_table`-arvoa.
- `sync_table` arvoilla voidaan määritellä tarkat arvot, joita halutaan synkronoida.
- `sync_table_query` sisältää ERP-synkronoimisen lopputuloksen. ERP-synkronoiminen synkkaa kahden ERP-järjestelmän välillä halutut tiedot.
- `sync_table_method`-arvolla voidaan tarkentaa mitä tietoja halutaan synkronoida tietystä päätteestä. Arvoksi voidaan mm. pistää `new`, jonka myötä voidaan tarkentaan, että päätteestä halutaan vain uudet.
- `no_sync_table`-arvolla voidaan tarkentaa, mitä taulua ei haluta synkronoida.
- `db_target_id`-arvolla voidaan määritellä kuinka moneen järjestelmään synkronoidaan.

`db-sync.lua`-skripti on laaja skripti, jonka avulla voidaan synkronoida Capacic-järjestelmän tietokantaa ulkoisista päätepisteistä. Pelkistetysti skripti toimii seuraavasti:

- Suoritetaan check-vaihe, jossa tarkastellaan synkattavien tietuetten määrä.
- `upperLevelPreference`-vaihe, jossa haetaan paikalliset tiedot. Seuraavassa järjestyksessä riippuen löytyykö tietoja: levy -> tietokanta -> käytetään perusarvoja.
- `tableIterator`-vaiheessa käydään läpi kaikki `source_id` ja `target_id` arvot.
- Mikäli "loop all" on päällä voidaan tarkastaa mitä voidaan synkronoida ja mitä ei.
- Taulun lista käydään läpi, tämän aikana katsotaan mitä pitäisi synkronoida ja mitä ei.
- Katsotaan onko `sync_table` synkronoitavien listalla.
- Mikäli tietokanta yhteys on saavutettu voidaan tarkastella `source_id`:sta löytyykö taulu `tableExists()`-funktion avulla.
- `checkDatabase`-vaiheessa verrataan JSONia kohdetietokantaan. Jos arvot eivät täsmää voidaan suorittaa SQL-kysely, jolla muokataan tietokanta täsmämään JSON:n kanssa.
- Seuraavaksi määritellään "generic show"-arvot, ajetaan debug SQL-funktiot ja tarvittaessa ajetaan `connectionChange`.
- Db sync voidaan ajaa tietyin väliajoin asettamalla `sleep_seconds` arvoksi suurempi kuin nolla.
- Ajetaan `checkSyntable()`-funktio.
- `default_query.json`-tiedostossa löytyvää `query_name`-arvoa käytetään, jos JSON:ssa ei ole määritelty arvoa.
- `table_name-record_type` voidaan määritellään esim. `resource-load_group`
- Esimerkki miten Capacic-järjestelmään voidaan sisällyttää arvoja.
  - `modifyTimeFieldExt` (Capacic) -> `modifyTimeField` (4D), mikäli ei löydy voidaan käyttää `record_key`-arvoa.
- `syncRec` sisältää synkattavan tiedon tiedot, jota voidaan pitää globaalina muuttujana Capacic-järjestelmässä.
- Suoritetaan tietokantapyynnöt:
  - `fromCountAll`
  - `toConnTbl`
  - `toCountAll`
- Tietyt kentät muutetaan eri nimiseksi mm. 4D:n uniikki `id`-kenttä muutetaan `uuid`:ksi.
- Etsitään muutos ID vanhoista tiedoista, mikäli tuotteita ei lisätty eikä poistettu.
- Jos määrät eivät täsmää, verrataan tietueita mitä on lisätty tai poistettu.
- Isoimman muutoksen ID etsitään (`target_id`) kohdetaulusta, verrataan `prevModifyId`:tä ja tietokannasta etsitään suurin `time_modify`-kenttä.
- Etsitään lähdetaulusta halutut tietuet käyttäen `runQuery()`-funktiota.
- Parametrin arvon perusteella etsitään tietokannasta `modifyId` tai muutos ID, joka on suurempi kuin viimeisin muutos ID.
- Haetaan ID:n perusteella ne tiedot, mitkä ovat muuttuneet edellisen synkronausoperaation jälkeen.
- `tableIterator` antaa `checkSyncTable`-callbackin, jos palauttaa false-arvon niin funktio palauttaa nil-arvon.
- Lasketaan paljonko on synkronoitu.
- Tämän jälkeen tiedot kopioidaan `copyLoop()`-, `copyData()`- ja `copyCallback`-funktioiden avulla.
- Taulun kentät luetaan.
- Synkronoiminen suoritetaan pienissä osioissa, jonka määrittelee `batchSize`-arvo.
- Synkronoidut arvot sisällytetään `sync_rec`-muuttujaan.
- Mikäli `full_compare` ei ole asetettu arvoksi `0`, tullaan vertaamaan kaikki `modify_id`-arvot.
- Ajetaan `moveData()`-funktio, jolle annetaan `runQuery()`-funktiosta tulevat tietuet.
- Sykronoimisessa hyödynnetään `max_error_count`-arvoa, joka määrittelee kuinka monta virhettä saa tapahtua ennen kuin ohjelma lopettaa operaation. 4D:ssä ja Postgre:ssa voi esiintyä virheitä arvoista joita ei ole määritelty, jotka voidaan tällä ylittää, jotta ohjelma on mahdollista ajaa production-ympäristössä ongelmitta.
