
# Database Synchronization Sync Plan Logic

## What does "trust previous" mean?

In this context, **"trust previous"** refers to whether the system can rely on the last record id (or "modify id") read from the target database during the previous sync. This id acts as a change marker to detect which records have changed since the last sync.

If `trust previous = true`, the sync logic can use incremental methods—only syncing records that have changed since the last trusted marker. If `trust previous = false`, the system cannot rely on the previous marker, so it must perform a full comparison or resync to ensure data consistency.

This flag is determined by whether a valid previous sync marker (last record id from the target database) exists and whether the system/user configuration allows trusting it. If not trusted, the sync plan always includes a full compare (`changed`) or a full add, never just incremental sync.

## 1. Target has more rows (`source total record count < target total record count`)

**When `trust previous = false`:**

- **Plan:** `delete`, `add`, `changed`
- **Reason:**
 	- "target has more rows => delete extras"
 	- "untrusted previous modify id => add then full compare"
- **Comment:** After delete, must do full add and compare. This is correct.

---

## 2. Counts equal (`source total record count = target total record count`)

### a) `changed > 0`, `trust previous = false`

- **If there is a previous sync marker:**
 	- **Plan:** `incremental`, `changed`
 	- **Reason:**
  		- "counts equal & untrusted previous modify id => incremental+full"
- **If there is no previous sync marker:**
 	- **Plan:** `changed`
 	- **Reason:**
  		- "counts equal & untrusted previous modify id => full compare"
- **Comment:** Must do full compare if can't trust previous. This is correct.

### b) `changed = 0`, `trust previous = false`

- **Plan:** _(none, just "row count and change count unchanged => nothing to sync")_
- **Comment:** This is correct.

---

## 3. Source has more rows (`source total record count > target total record count`)

### a) `changed > 0`, `trust previous = false`

- **If there is a previous sync marker:**
 	- **Plan:** `add`, `incremental`, `changed`
 	- **Reason:**
  		- "source has more rows & changed > 0"
  		- "untrusted previous modify id => incremental + full"
- **If there is no previous sync marker:**
 	- **Plan:** `add`, `changed`
 	- **Reason:**
  		- "source has more rows & changed > 0"
- **Comment:** Must do full compare if can't trust previous. This is correct.

### b) `changed = 0`

- **Plan:** `add`, (`changed` if not trust previous)
- **Note:** `trust previous` is always set to false here (by patch).
- **Comment:** Must do full compare if can't trust previous. This is correct.

---

## 4. Target empty (`target total record count = 0 && source total record count > 0`)

- **Plan:** `add`
- **Note:** `trust previous` is passed through, but this case is always a full add, so `trust previous` doesn't matter.
- **Comment:** This is correct.

---

## Summary

> All logic paths when `trust previous = false` result in a plan that includes a full compare (`changed`) or a full add, as required. There are no cases where an incremental-only sync is done when previous cannot be trusted.
