# Work Center States

## Key Concepts

Smart work tracking with break handling and continue functionality.

## State Flow Chart

```mermaid
flowchart TD
    Start([<img src="image/play.svg"> Start]) --> Ready[<img src="image/circle-check.svg"> Ready]

    Ready --> Edit[<img src="image/pen.svg"> Edit]
    Edit --> Material[<img src="image/cart-flatbed-boxes.svg"> Material]
    Material --> Setup[<img src="image/wrench.svg"> Setup]
    Setup --> Working[<img src="image/play.svg"> Working]

    Working -->|Complete work| Stop[<img src="image/stop.svg"> Stop]
    Working -->|Take break| Break[<img src="image/hourglass-clock.svg"> Break]
    Working -->|Meal time| Eating[<img src="image/utensils.svg"> Eating]
    Working -->|Finish shift| Exit[<img src="image/right-from-bracket.svg"> Exit]

    Stop -->|Enter amounts| Complete{<img src="image/flag-checkered.svg"> Complete?}
    Complete -->|Yes| Ready
    Complete -->|No| Working

    Break --> Ready
    Eating --> Ready
    Exit --> Ready

    Ready -->|On-break work| Continue[<img src="image/play.svg"> Continue]
    Continue --> Edit

    classDef normal fill:#e3f2fd,stroke:#2196f3,color:#000
    classDef unprod fill:#ffebee,stroke:#f44336,color:#000
    classDef ready fill:#e8f5e8,stroke:#4caf50,color:#000
    classDef complete fill:#fff3e0,stroke:#ff9800,color:#000

    class Ready ready
    class Edit normal
    class Material normal
    class Setup normal
    class Working normal
    class Stop normal
    class Complete complete
    class Continue normal

    class Break unprod
    class Eating unprod
    class Exit unprod

    class Start ready
```

**Workflow:** Ready → Edit → Material → Setup → Working → Stop → Complete? → Ready

**Continue Path:** Ready (on-break work) → Continue → Edit → Material → Setup → Working

**Break Flow:** Working → Break/Eating/Exit → Ready

## Button Colors

- **Grey** - Ready
- **Blue** - Active work, Continue
- **Black** - Stopped
- **Green** - Material
- **Brown** - Setup
- **Red** - Break

*Continue button is blue (action, not state)*

## Daily Workflow

**Sequence:** Ready → Edit → Material → Setup → Working → Stop → Complete? → Ready

**Break handling:** Working → Break/Eating/Exit → Ready

**Continue Logic:**
- **Continue** appears when you have on-break work (started_amount > 0, active_state = on_break)
- **Continue** copies previous started_amount automatically
- **Continue** → Edit → resume work flow
- **Ready** for fresh work or return from breaks

**Work completion:** When Produced + Failed ≥ Started, Save becomes Finish → Ready

## Important Concepts

### Continue Button Intelligence
- Appears automatically when you have unfinished work
- Copies previous work amounts automatically
- Blue color distinguishes it from state buttons
- Remembers if you were continuing work during breaks

### Work Completion
- **Save becomes Finish** when Produced + Failed ≥ Started
- **Complete? decision** routes to Ready (finished) or Continue (unfinished)
- **Work amounts** tracked accurately across breaks and continues

### Machine Safety
- **Exit blocked** while machine is running
- **Safety states checked**: stop, material, setup, working
- **Auto-clear warnings** when machine stopped

### Unfinished Work Protection
- **Exit prevented** with active unfinished work (working, setup, material)
- **Allowed exit states**: Edit, Ready, Stop (safely paused)
- **Error messages** show count of unfinished work phases
- **Grid filters** show only your unfinished work

## Key Workflows

**New Job:** Ready → Edit → Material → Setup → Working

**Break Return:** Stop → Break/Eating → Return → Ready/Continue

**Continue Work:** Continue button appears automatically → amounts copied → Working

**Switch Work:** Stop → new order → Edit → Material → Setup → Working


## Troubleshooting

- **Red borders** = invalid amounts
- **Grey buttons** = select your name first
- **Can't exit** = machine running or unfinished work
- **Error messages** = follow instructions or ask supervisor

## Key Reminders

- One button always selected (always in a state)
- Stop before Break
- Finish work completely before leaving
