// form/nc/nc-work-center/nc-work-center-util.js

let personSerieIdx
export function workInProgress(rec) {
	return (
		rec.current.started_amount > 0 &&
		(rec.current.produced_amount === 0 || rec.current.produced_amount === '') &&
		(rec.current.failed_amount === 0 || rec.current.failed_amount === '')
	)
}

export function updateCurrentAndPersonFunction(state, nc, dt, message) {
	const rec = state.rec
	const hdr = state.hdr
	const arr = state.arr
	const recData = nc.recData
	const recDataSet = nc.recDataSet
	personSerieIdx = { [rec.constant.product_work_serie.person]: true, [rec.constant.product_work_serie.person_machine]: true }
	const onBreakIdx = {
		[rec.constant.active_state.on_break]: true,
		[rec.constant.active_state.continue_on_break]: true
	}

	function setDefaultToCurrent(rowRec) {
		let value
		for (const key of rec.current_field_set) {
			value = rowRec && recData(rowRec, key)
			if (value == null) {
				value = rec.current_field_set_default[key]
			}
			if (value != null) {
				if (typeof rec.current_field_set_default[key] === 'number') {
					recDataSet(rec.current, key, Number(value))
				} else {
					recDataSet(rec.current, key, value)
				}
			} else {
				// Clear the field if it doesn't exist in the new row
				value = recData(rec.current, key)
				if (value) {
					if (nc.isArray(value)) {
						recDataSet(rec.current, key, [])
					} else if (nc.isObject(value)) {
						recDataSet(rec.current, key, {})
					}
				}
			}
		}
	}

	function setField(infoField, infoRec) {
		let prevConcatValue = ''
		rec.current.calc[infoField] = ''
		let val
		for (const key of rec[infoField + '_field']) {
			val = infoRec && recData(infoRec, key)
			if (val == null)
				if (key === '[you_started]') {
					val = rec.current.started_amount
				} else if (key === '[other_started]') {
					val = infoRec.calc.started_amount - rec.current.started_amount
					/* val = rec.current.calc.started_person_array.filter(item => item.person_id !== rec.person)
							.map(item => item.started_amount)
							.reduce((a, b) => a + b, 0) || 0 */
				}
			if (val != null) {
				if (val !== '') {
					if (rec.field_format[key]) {
						val = dt.formatDate(val, rec.field_format[key])
					}
					// val = String(val)
					rec.current.calc[infoField] += prevConcatValue + val // .substring(0, 100)
				}
			} else {
				prevConcatValue = key
			}
		}
		rec.current.calc.info = rec.current.calc.work_info + rec.current.calc.time_info + rec.current.calc.amount_info + rec.current.calc.done_info
	}

	function setPersonStateToCurrent(workPhaseRec) {
		let value
		for (const key of Object.keys(rec.person_state_field)) {
			value = workPhaseRec[key]
			if (value == null) {
				value = rec.person_state_field[key]
			}
			recDataSet(rec.current, key, value)
		}
	}

	function setPrev() {
		rec.current.prev_started_amount = rec.current.started_amount
		rec.current.prev_produced_amount = rec.current.produced_amount
		rec.current.prev_failed_amount = rec.current.failed_amount
		rec.current.prev_info = rec.current.info
	}

	function fixPerson() {
		if ((arr.person.length != 1 || arr.person[0].value != '') && nc.recordArrayIndex(arr.person, 'value', rec.person) < 0) {
			rec.person = ''
		}
	}

	return function updateCurrentAndPerson(fromRec, workPhaseRec) {
		fixPerson()
		const personWorkPhase = state.data?.work_phase_actual_open?.filter(item => item.person_id === rec.person) || []
		const personOpenWorkPhase = personWorkPhase.filter(item => dt.isZeroDate(item.end_time))
		const unproductiveWorkPhase = personOpenWorkPhase.filter(
			item => item.production_order_id === rec.constant.unproductive_id && item.work_phase_state !== rec.constant.unproductive_work_change_state
		)
		if (unproductiveWorkPhase.length > 1) {
			message.setWarning(state, 'more than one unproductive work phase was found')
		}
		rec.current.enterable = !!rec.person // to boolean
		if (rec.selected_work_row <= 0) {
			setDefaultToCurrent()
			rec.current.started_amount = 0
			rec.current.info = ''
			setPrev()
			rec.current.enterable = false
			rec.current.startable = false
			return
		}
		setPrev()
		let rowRec = fromRec || state.grid.work.data[rec.selected_work_row - 1] // nc.grid.activatedRow(state, 'work')
		const machineWorkPhase =
			rowRec &&
			personOpenWorkPhase.find(item => item.production_order_id === rowRec.production_order_id && item.work_phase_number === rowRec.work_phase_number && item.serie === 'machine')
		if (machineWorkPhase) {
			rec.machine_state = machineWorkPhase.work_phase_state
			rec.machine_stop_type = arr.machine_stop_type[0]?.value || 'stop' // machineWorkPhase.work_phase_state
		} else {
			rec.machine_state = ''
			rec.machine_stop_type = arr.machine_stop_type[0]?.value || 'stop'
		}
		rec.machine_stop_type_idx = nc.recordArrayIndex(arr.machine_stop_type, 'value', rec.machine_stop_type) || 0
		// Clear machine running warning if machine is stopped
		if (rec.warning_text && rec.warning_text.includes('Cannot exit while machine is running') && (!rec.current.machine_state || rec.current.machine_state === 'stop')) {
			rec.warning_text = ''
		}
		if (workPhaseRec == null && rowRec) {
			workPhaseRec = personOpenWorkPhase.find(
				item => item.production_order_id === rowRec.production_order_id && item.work_phase_number === rowRec.work_phase_number && personSerieIdx[item.serie]
			)
			if (!workPhaseRec && unproductiveWorkPhase.length >= 1) {
				rec.current.startable = false
				workPhaseRec = personWorkPhase.find(
					item => item.production_order_id === rowRec.production_order_id && item.work_phase_number === rowRec.work_phase_number && personSerieIdx[item.serie]
				)
			}
		}
		if (!workPhaseRec || (!rec.person_in_production && !dt.isZeroDate(workPhaseRec.end_time))) {
			// If person is in unproductive button group, only allow open work phases or use unproductive phase
			workPhaseRec = unproductiveWorkPhase[0] || {}
			rec.current.started_amount = 0
			rec.current.produced_amount = 0
			rec.current.failed_amount = 0
			rec.current.info = ''
			setPrev()
		}
		if (!workPhaseRec?.work_phase_state) {
			workPhaseRec.work_phase_state = ''
		}
		rec.current.person_state = workPhaseRec.work_phase_state
		/* if (rec.current.person_state !== '') {
			rec.info_open = true
		} */
		function setState(state) {
			if (state == null) {
				message.setError(state, `empty state to set`)
				return
			}
			// Keep person_state in sync with the UI and use hdr.work_center mapping if present
			if (hdr.work_center && hdr.work_center[state] != null) {
				hdr.work_center.action = hdr.work_center[state]
			} else if (state === rec.constant.phase_state.empty) {
				hdr.work_center.action = hdr.work_center.ready
			} else {
				// fallback: set to provided state if no mapping exists
				hdr.work_center.action = hdr.work_center[state] || hdr.work_center.ready
			}
		}
		const allowedStates = nc.invertTable(rec.constant.phase_state)
		if (!allowedStates[workPhaseRec.work_phase_state]) {
			message.setError(workPhaseRec.work_phase_state, `unknown person state '${workPhaseRec.work_phase_state}-${rec.current.person_state}'`)
			setState(rec.constant.phase_state.empty)
		} else {
			setState(workPhaseRec.work_phase_state)
		}
		if (workPhaseRec.production_order_id === rec.constant.unproductive_id) {
			// For unproductive production orders, use the work_phase_state (e.g. 'break', 'eating') as the person_state.
			rec.person_state_icon =
				arr.person_state_unproductive.find(item => item.value === workPhaseRec.work_phase_state)?.icon ||
				arr.unproductive_button_group.find(item => item.value === workPhaseRec.work_phase_state)?.icon
		}
		setDefaultToCurrent(rowRec)
		if (rowRec) {
			setField('time_info', rowRec)
			setField('amount_info', rowRec)
			setField('work_info', rowRec)
			setField('done_info', rowRec)
		}
		setPersonStateToCurrent(workPhaseRec)
		arr.machine = arr.resource?.filter(item => item.value === rec.current.resource_id) || []
		rec.machine = rec.current.resource_id
		rec.separate_machine_run = rec.keep_running_load_group[rec.machine] ? 1 : 0
		rec.current.virtual = rec.current.production_order_id.startsWith(rec.constant.virtual_production_order_prefix)
		rec.current.startable = rec.constant.production_order_state_can_start[rec.current.pro.production_order_state]
		// rec.current.can_run = rec.current.started_amount >= rec.min_start_amount
		if (!rec.person || rec.selected_work_row < 1) {
			rec.current.startable = false
		}
		/* if (rec.current.person_state === '' && rec.current.started_amount <= 0) {
			// rec.current.can_run = false
		} */
		if (rec.current.started_amount < rec.current.produced_amount + rec.current.failed_amount || unproductiveWorkPhase.length >= 1) {
			rec.current.startable = false
		}
		if (rec.current.started_amount === 0 || rec.current.started_amount === '') {
			rec.current.started_amount = 0
			rec.current.startable = false
		}
		rec.current.calc.can_start_amount = rowRec?.calc?.can_start_amount || 0
		// Track if work has been started but not yet completed with produced/failed amounts
		rec.current.work_in_progress = workInProgress(rec)
		if (rec.current.calc.can_start_amount < 0 && rec.current.started_amount > 0) {
			// Use localized template from hdr with placeholders {started} and {can_start}
			const tpl = hdr.work_center.start_amount_error || 'please fix hdr.work_center.start_amount_error in form/nc/nc-work-center/hdr.json'
			rec.error_message = tpl.replace('{{started}}', rec.current.started_amount).replace('{{can_start}}', rec.current.started_amount + rec.current.calc.can_start_amount)
			/* } else if (rec.current.startable && rec.current.calc.can_start_amount <= 0) {
			const tpl = hdr.work_center.start_amount_zero || 'please fix hdr.work_center.start_amount_zero in form/nc/nc-work-center/hdr.json' "Can start amount {{can_start}} is less than 0."
			rec.error_message = tpl.replace('{{can_start}}', rec.current.calc.can_start_amount) */
		} else {
			rec.error_message = ''
		}
		// todo: wrong logic here?
		const unfinishedWorkPhase = personOpenWorkPhase.filter(item => item.production_order_id !== rec.constant.unproductive_id)

		// compute lengths for potential debugging; do not log to console in production
		if (unproductiveWorkPhase.length > 1) {
			message.setWarning(state, 'more than one unproductive work phase was found')
		}
		// Set error message if there are unfinished works, but allow exit if work phases are in edit/ready/stop states
		if (unfinishedWorkPhase.length > 0 && !rec.person_in_production) {
			// Check if all unfinished work phases are in allowed states (edit, ready, stop)
			const hasOnlyAllowedStates = unfinishedWorkPhase.every(phase => phase.work_phase_state === 'edit' || phase.work_phase_state === 'ready' || phase.work_phase_state === 'stop')
			if (!hasOnlyAllowedStates) {
				rec.error_message = `Cannot exit - you have ${unfinishedWorkPhase.length} unfinished work phase(s) that are not in edit/ready/stop states. Please finish your work before leaving.`
			} else {
				// Clear the error message since all unfinished work phases are in allowed states
				rec.error_message = ''
			}
		} else {
			// Check if person is in unproductive state and prevent starting work
			const isInUnproductiveState = unproductiveWorkPhase.some(phase => phase.work_phase_state !== rec.constant.unproductive_work_change_state)
			if (isInUnproductiveState && rec.person_in_production) {
				rec.current.enterable = false
				const unproductiveState = unproductiveWorkPhase[0]?.work_phase_state || 'unproductive'
				rec.error_message = `Cannot start work while in '${unproductiveState}' state. Please go to ready state first.`
			}
		}
		// Set continue flag if there's a person on break with previously started amount
		rec.current.continue =
			rec.current.started_amount === 0 &&
			rec.current?.calc?.started_person_array?.some(item => item.person_id === rec.person && item.started_amount > 0 && onBreakIdx[item.active_state])
	}
}
