# Work Center States

## Key Concepts

Smart work tracking with break handling and continue functionality.

## State Flow Chart

```mermaid
flowchart TD
    Start([<img src="image/play.svg"> Start]) --> Ready[<img src="image/circle-check.svg"> Ready]

    Ready --> Edit[<img src="image/pen.svg"> Edit]
    Edit --> Material[<img src="image/cart-flatbed-boxes.svg"> Material]
    Material --> Setup[<img src="image/wrench.svg"> Setup]
    Setup --> Working[<img src="image/play.svg"> Working]

    Working -->|Complete work| Stop[<img src="image/stop.svg"> Stop]
    Working -->|Take break| Break[<img src="image/hourglass-clock.svg"> Break]
    Working -->|Meal time| Eating[<img src="image/utensils.svg"> Eating]
    Working -->|Finish shift| Exit[<img src="image/right-from-bracket.svg"> Exit]

    Stop -->|Enter amounts| Complete{<img src="image/flag-checkered.svg"> Complete?}
    Complete -->|Yes| Ready
    Complete -->|No| Working

    Break --> Ready
    Eating --> Ready
    Exit --> Ready

    Ready -->|On-break work| Continue[<img src="image/play.svg"> Continue]
    Continue --> Edit

    classDef normal fill:#e3f2fd,stroke:#2196f3,color:#000
    classDef unprod fill:#ffebee,stroke:#f44336,color:#000
    classDef ready fill:#e8f5e8,stroke:#4caf50,color:#000
    classDef complete fill:#fff3e0,stroke:#ff9800,color:#000

    class Ready ready
    class Edit normal
    class Material normal
    class Setup normal
    class Working normal
    class Stop normal
    class Complete complete
    class Continue normal

    class Break unprod
    class Eating unprod
    class Exit unprod

    class Start ready
```

**Workflow:** Ready → Edit → Material → Setup → Working → Stop → Complete? → Ready

**Continue Path:** Ready (on-break work) → Continue → Edit → Material → Setup → Working

**Break Flow:** Working → Break/Eating/Exit → Ready

## Button Colors

- **Grey** - Ready
- **Blue** - Active work, Continue
- **Black** - Stopped
- **Green** - Material
- **Brown** - Setup
- **Red** - Break

*Continue button is blue (action, not state)*

## Daily Workflow

**Sequence:** Ready → Edit → Material → Setup → Working → Stop → Complete? → Ready

**Break handling:** Working → Break/Eating/Exit → Ready

**Continue Logic:**

- **Continue** appears when you have on-break work (started_amount > 0, active_state = on_break)
- **Continue** copies previous started_amount automatically
- **Continue** → Edit → resume work flow
- **Ready** for fresh work or return from breaks

**Work completion:** When Produced + Failed ≥ Started, Save becomes Finish → Ready

## Important Concepts

### Continue Button Intelligence

- Appears automatically when you have unfinished work
- Copies previous work amounts automatically
- Blue color distinguishes it from state buttons
- Remembers if you were continuing work during breaks

### Work Completion

- **Save becomes Finish** when Produced + Failed ≥ Started
- **Complete? decision** routes to Ready (finished) or Continue (unfinished)
- **Work amounts** tracked accurately across breaks and continues

### Machine Safety

- **Exit blocked** while machine is running
- **Safety states checked**: stop, material, setup, working
- **Auto-clear warnings** when machine stopped

### Unfinished Work Protection

- **Exit prevented** with active unfinished work (working, setup, material)
- **Allowed exit states**: Edit, Ready, Stop (safely paused)
- **Error messages** show count of unfinished work phases
- **Grid filters** show only your unfinished work

## Key Workflows

**New Job:** Ready → Edit → Material → Setup → Working

**Break Return:** Stop → Break/Eating → Return → Ready/Continue

**Continue Work:** Continue button appears automatically → amounts copied → Working

**Switch Work:** Stop → new order → Edit → Material → Setup → Working

## Troubleshooting

- **Red borders** = invalid amounts
- **Grey buttons** = select your name first
- **Can't exit** = machine running or unfinished work
- **Error messages** = follow instructions or ask supervisor

## Material Collection

When in **Material** state, you can collect raw materials needed for production before starting work.

### Material Collection Interface

When you press the **Material** button, the interface shows:

**Collection Status Row:**

- **Need**: Total material needed (started_amount × need per unit)
- **Collected**: Material already collected
- **Remaining**: Material still needed to collect
- **Stock Info**: Details about selected stock parcel

**Action Buttons:**

- **Collect** (+): Collect selected stock parcel for work
- **Remove** (-): Remove collection from selected parcel
- **Confirm**: Confirm collections and start work

### Material Collection Workflow

**Step 1: Enter Material State**

- Select work order and press **Material** button
- Collect tab automatically opens with available stock locations
- Need amounts calculated automatically based on work amount

**Step 2: View Available Materials**

- Stock location grid shows all available materials for your work order
- Each row shows: product, location, batch, amount, and availability
- Green rows = available stock, red rows = insufficient stock

**Step 3: Select Stock Parcel**

- Click on a stock location row to select it
- Stock info displays selected parcel details
- Verify this is the material you want to collect

**Step 4: Collect Material**

- With stock parcel selected, press **Collect** button
- Material amount is added to collected total
- Stock location grid refreshes to show updated availability
- Repeat for all needed materials

**Step 5: Remove Collections (if needed)**

- Select collected stock parcel and press **Remove** button
- Collection is removed and amount deducted from collected total
- Stock availability restored in grid

**Step 6: Confirm and Start Work**

- When all needed materials are collected, press **Confirm** button
- System creates new stock records:
  - Collected materials moved to machine location
  - Remaining materials stay in stock with updated amounts
  - Original stock records are closed
- Work automatically starts in **Working** state

### Important Notes

- **Automatic Loading**: Stock locations load automatically when entering Material state
- **Real-time Updates**: Need/collected/remaining amounts update immediately
- **Stock Safety**: Original stock records are preserved, only new records created
- **Work Continuation**: Confirm button automatically transitions to Working state
- **Batch Tracking**: All collection data is preserved with batch and source information

### Troubleshooting Material Collection

- **No stock shown**: Check if materials are available in inventory
- **Collect button disabled**: Select a stock location row first
- **Amounts incorrect**: Verify started amount and material requirements
- **Confirm not working**: Ensure some materials have been collected first

## Can Start Amounts

The work center displays two important "can start" values that help you understand production constraints:

### Can Start (Production Flow)

**Location**: Work grid, "Can start" column

**What it shows**: How many products can be started based on production flow and previous work phases

**How it's calculated**:

- Starts with the total amount to produce for the production order
- Subtracts amounts already completed in previous work phases
- Subtracts amounts already started or produced in the current phase
- Shows the remaining amount that can logically be started in this phase

**When it's 0**: Previous phases need to be completed first before you can start more work in this phase

**Visual indicators**:

- **White text**: 0 (cannot start)
- **Dark red text**: Negative values (production flow issues)
- **Normal text**: Positive values (can start this amount)

### Mat. Can Start (Material Constraints)

**Location**: Work grid, "Mat. can start" column

**What it shows**: How many products can be started based on available material stock

**How it's calculated**:

- Checks all materials required for the production order
- For each material: stock_balance ÷ amount_needed_per_product
- Takes the minimum value from all required materials (the limiting factor)
- Shows how many complete products you can make with current materials

**When it's lower than "Can start"**: You're limited by material availability, not production flow

**Visual indicators**:

- **Bold red text**: 0 or negative (no materials available)
- **Normal text**: Positive values (materials available for this amount)

### Material Grid Can Start

**Location**: Material grid, "Can start" column

**What it shows**: How many products can be made based on each individual material's stock

**How it's calculated**: stock_balance ÷ material_amount_per_product (rounded down)

**Usage**: Helps identify which specific materials are limiting your production

### Production Planning with Can Start Amounts

**Green rows** in work grid:

- Both production flow and materials allow starting work
- `can_start_amount > 0` AND `material_can_start >= can_start_amount`
- Production order state is "confirmed"

**Dark red rows** in work grid:

- Materials are more limiting than production flow
- `pro.calc.material_can_start < prwo.calc.can_start_amount`
- You need to order/wait for materials before production

**Planning workflow**:

1. Check "Can start" column for production flow constraints
2. Check "Mat. can start" column for material constraints
3. Use material grid to identify specific material shortages
4. Order needed materials or adjust production plans

### Examples

**Example 1 - Production Flow Limited**:

- Can start: 5
- Mat. can start: 20
- **Result**: You can start 5 products (limited by previous phases)

**Example 2 - Material Limited**:

- Can start: 15
- Mat. can start: 3
- **Result**: You can only start 3 products (limited by materials)

**Example 3 - No Constraints**:

- Can start: 10
- Mat. can start: 10
- **Result**: You can start 10 products (no limitations)

## Real-time Updates

### Info Field Sharing

**Started amounts** and **notes** you enter are automatically shared with other workers on the same work phase. When you update amounts or add notes, other people can see your changes immediately.

### Color Coding

**Person column colors:**

- **Blue highlight** - Your work entries
- **Red highlight** - Stopped work entries
- **Grey highlight** - Other workers' entries
- **Orange background** - Currently on break

**Notes colors:** Same color coding as person entries to show who added each note

## Work Grid Display

**Italic/slanted text** in the work grid comes from production order data and is shared across multiple work phases that belong to the same production order. This text provides context about the production order that applies to all related work phases.

## Key Reminders

- One button always selected (always in a state)
- Stop before Break
- Finish work completely before leaving
- Collect all required materials before confirming
- Verify stock parcel details before collecting
- Your work updates are visible to others automatically
