// plugin/vue-renderer/component/nc-form/nc-form-col-row.js
// nc-form/nc-form-col-row.js
// /src/components/nc-form/nc-form-col-row.js

import { computed } from '../../vuelib.js'

function setWarning(vm, ...args) {
	console.warn(...args)
}

function calculateRatio(str, obj, widthHeight, event) {
	if (typeof str !== 'string') {
		if (event !== 'update') {
			setWarning(null, widthHeight + ' parameter type is not string: ', typeof str, str, obj)
		}
		if (typeof str === 'number') {
			return str
		} else {
			return 'auto'
		}
	}
	let arr = str.split('/')
	if (arr.length !== 2) {
		if (event !== 'update') {
			if (arr.length > 2) setWarning(null, widthHeight + ` parameter must contain only one '/' :`, str, obj)
			else setWarning(null, widthHeight + ` parameter does not contain '/' :`, str, obj)
		}
		return 'auto'
	}
	let num1 = Number(arr[0])
	let num2 = Number(arr[1])
	if (num2 <= 0 || num1 > num2 || isNaN(num1) || isNaN(num2)) {
		if (event !== 'update') {
			// if (currentUrl() !== '/editor/layout') {
			// no errors during input of a width
			setWarning(null, widthHeight + ' parameter does not resolve to valid number:', str, obj)
			// }
		}
		return 'auto'
	}
	return num1 / num2
}

export function rowColStyle(props, setDefaultWidth, event) {
	if (!props) return ''
	let style = props.style || ''
	if (setDefaultWidth === true && !props.width) {
		style = style + 'width:100%;'
	} else if (setDefaultWidth && !props.width) {
		style = style + 'width:' + setDefaultWidth + ';'
	}
	if (props.width) {
		// search for '/', for ex. width='1/3'
		if (typeof props.width !== 'string') {
			console.error('row or column width property is not string:', props.width)
			return
		}
		if (props.width.search('/') >= 0) {
			let percent = calculateRatio(props.width, props, 'width', event) * 100
			if (percent === 'auto') {
				// style = 'width:auto;' + style
			} else if (typeof style === 'object') {
				if (style.width == null) {
					style.width = percent + '%'
				}
			} else if (style.search('width:') < 0) {
				style = 'width:' + percent + '%;' + style
			}
		} else if (typeof style === 'object') {
			if (style.width == null) {
				style.width = props.width
			}
		} else if (style.search('width:') < 0) {
			style = style + 'width:' + props.width + ';' + style
		}
	}
	if (props.height) {
		if (props.height.search('/') >= 0) {
			if (style !== '') {
				style = style + ' '
			}
			let percent = calculateRatio(props.height, props, 'height', event) * 100
			if (typeof style === 'object') {
				if (style.height == null) {
					if (percent === 'auto') {
						style.height = 'auto'
					} else {
						style.height = percent + '%'
					}
				}
			} else if (percent === 'auto') {
				style = 'height:auto;' + style
			} else if (style.search('height:') < 0) {
				style = style + 'height:' + percent + '%;' + style
			}
		} else if (typeof style === 'object') {
			if (style.height == null) {
				style.height = props.height
			}
		} else if (style.search('height:') < 0) {
			style = style + 'height:' + props.height + ';' + style
		}
	}
	// console.log(`🚀 ~ file: nc-form-col-row.js ~ line 81 ~ rowColStyle ~ '${style}'`)
	return style
}

export default function createComponent(name, defaultWidth) {
	return {
		name: name,
		props: {
			style: {
				type: [String, Object],
				default: undefined
			},
			width: {
				type: String,
				default: undefined
			},
			height: {
				type: String,
				default: undefined
			}
		},
		setup(props) {
			// console.debug(`created component ${name}, defaultWidth: ${defaultWidth}`)
			const calculatedStyle = computed(() => {
				return rowColStyle(props, defaultWidth)
			})
			return { calculatedStyle }
		}
	}
}
