// plugin/vue-renderer/component/nc-barcode/nc-barcode.js

// src/components/nc-barcode/nc-barcode.vue
import { onMounted } from '../../vuelib.js' // server component must have vue imports
import nc from '../../core/nc-util.js'
// import JsBarcode from 'jsbarcode'

export default {
	render: render,
	name: 'NcBarcode',
	props: {
		id: {
			type: String,
			default: 'nc-barcode-1'
		},
		model: {
			type: String,
			default: undefined,
			required: true
		},
		format: {
			type: String,
			default: 'CODE128'
		},
		codeWidth: {
			type: [Number, String],
			default: undefined,
			description: 'Width of a single bar in pixels, default is 2.'
		},
		codeHeight: {
			type: [Number, String],
			default: '60px' // shows also text on the bottom
		}
	},
	setup(props) {
		const state = inject('state')
		if (typeof window === 'undefined') {
			return // server render fix
		}
		onMounted(() => {
			watchEffect(() => {
				const value = nc.recData(state, props.model)
				const options = {
					format: props.format
				}
				if (props.codeHeight) {
					options.height = props.codeHeight // setting undefined or null will prevent drawing
				}
				if (props.codeWidth) {
					options.width = props.codeWidth
				}
				if (typeof JsBarcode !== 'undefined') {
					JsBarcode('#' + props.id, value || ' ', options) // '' is not valid input for JsBarcode
				}
			})
		})
	}
}

// render code
import { openBlock as _openBlock, createElementBlock as _createElementBlock } from '../../vuelib.js'

const _hoisted_1 = ['id', 'model', 'format', 'code-width', 'code-height']

export function render(_ctx, _cache) {
	return (
		_openBlock(),
		_createElementBlock(
			'img',
			{
				class: 'nc-barcode',
				id: _ctx.id,
				model: _ctx.model,
				format: _ctx.format,
				'code-width': _ctx.codeWidth,
				'code-height': _ctx.codeHeight
			},
			null,
			8 /* PROPS */,
			_hoisted_1
		)
	)
}
