# Varaston arvo (stock value)

Sivu näyttää valitun tuotteen varaston arvon ja saldon valitulta päivältä, valitulla valuutalla. Sivulta voidaan myös luoda ja esikatsella varaston arvo-raportti, jonka tulostus onnistuu PDF-välilehdeltä.

_Stock-, Sales order ja Purhase order välilehdet?_

Sivu sisältää taulukon hallinta-elementit, välilehtivalikon, yleisnäkymätaulukon, täsmänäkymätaulukon ja pelkistetyn info-ruudun.

**Varaston arvo sivun rakennetta voidaan muuttaa rajoitetusti `arr.json`-tiedoston avulla, minkä vuoksi tiedoston kautta voidaan muokata välilehtiä ja mitä valuuttoja tuetaan. Syvemmät muutokset pitää tehdä suoraan `stock-value.json`- ja `stock-value.js`-tiedostoon.**

**Varaston arvo sivun muokkaaminen tapahtuu suurimmaksi osaksi manipuloimalla sivun state-arvoja, joilla määritellään mm. taulukkojen sisältöä ja miten sivu pitäisi renderöidä ensimmäisellä kerralla. Koska sivu sisältää monia tietokantakyselyjä, state-arvoja manipuloidaan tietokannasta saatujen tuloksien avulla, kun frontend lähettää POST-pyynnön uusien tietojen noutamiseksi. Tietokantakyselyjä määritellään `stock-value`-hakemiston kautta lisäämällä ja muokkaamalla olemassa olevia kyselyjä `query`-hakemistossa JSON-tiedostoina. Backend suorittaa haut komponentin prosessoinnin yhteydessä `grid.json`-tiedoston sisältämien määrityksien mukaisesti, minkä lopputuloksena tietokantakyselyn tulokset injektoidaan komponenttiin.**

**Tarvittavat laskennat tapahtuvat myös backendin puolella, mitkä määritellään `stock-value.lua`-tiedostossa.**

## Käsitteet

1. Ostohinta (purchase price) \* ostokerroin = omakustannushinta
2. Omakustannushinta (Cost price) \* katekerroin = myyntihinta
3. Myyntihinta (Product sales price) eli ulosmyyntihinta

## Laskentalogiikka

Varaston arvo-ruudussa (Stock value) voi vapaasti valita tarkasteltavan päivämäärän. Varaston arvo lasketaan em. päivän tilanteen mukaan. Järjestelmä hakee annetulla päivämäärällä viimeisimmän varastotapahtuman jälkeisen tilanteen. Näytön yläosan ruudussa ovat tuotteet ja alaosan ruudussa valitun tuotteen yksityiskohtaiset varastotapahtumat.

1. Varaston arvo-ruudussa voi vapaasti valita tarkasteltavan päivämäärän. Varaston arvo lasketaan em. päivän tilanteen mukaan valitulle tuotteelle.
2. Järjestelmä etsii em. päivää edeltävän viimeisimmän varastosaldon ja käyttää tätä arvoa laskennassa.
3. em. arvo näytetään listauksessa ylimpänä sinisellä fontilla.
4. Lisäystyyppiset tapahtumat (LI) kasvattavat aiempaa varastosaldoa (Used) uudeksi saldoksi (Remaining) Tämä arvo näytetään ylemmässä ruudussa Stock Balance-arvona.
5. Varastotapahtumien arvostus tapahtuu järjestelmänvalvojan tekemillä valinnoilla tapahtumakohtaisesti.

## Hallinta-elementti

Hallinta-elementeillä voidaan rajata taulukoissa näkyvää dataa.

Ensimmäinen rivi sisältää seuraavat valinnat:

- Value date: minkä päivän arvo halutaan näyttää
- Currency: millä valuutalla tulokset halutaan näyttää
- Product: hakutulosten rajaus niihin tuotteisiin, joiden tunnisteessa on syötetty teksti

Toisella, eli Options-rivillä on seuraavia valintoja:

- Show all stock events: näytä kaikki varastotapahtumat
- Hide zero balance rows: piilota nollarivit tai käytä erilaisia arvoja varastonarvon laskennassa
- Use cost price: omakustannushinta arvottaa tuotteen sen valmistuskustannuksilla
- Product price: tuotteen hinta arvottaa tuotteen sen ulosmyyntihinnalla
- Use sales price for own work: asettaa oman työn arvoksi sen ulosmyyntihinnan.

Huom. Options -rivi on vain järjestelmänvalvojan käytössä.

## Näkymät

Sivun eri näkymät ovat eritelty välilehtien taakse:

- Product: sisältää sivun perusnäkymän, josta voidaan tarkkailla varaston arvoa
- Pdf: sisältää tulostettavan PDF-raportin
- Stock: sisältää pelkistetyn listan tuotteista
- Sales order: sisältää myynnin saldon ja mitä kyseiset myyntitapahtumat vaativat
- Purchase order: sisältää listan tuotteita, joista on tehty ostotapahtuma

Riippuen millä välilehdellä käyttäjä on, välilehden alapuolella esiintyvät elementit saattavat vaihtua, jos elementti ei käytä kyseistä välilehteä. Päätaulukko, joka esiintyy välilehtivalikon alapuolella näyttää tuotteiden pelkistetyt tiedot kyseisellä päivällä. Käyttäjän valittua tietyn tuotteen listasta, siitä näytetään alempana esiintyvässä taulukossa tuotteeseen kohdistuvat tapahtumat haluttuun päivään asti. Info-näkymä, joka näkyy toisen taulukon oikealla puolella tai alla näytetään tapahtumat pelkistetysti, josta voidaan helposti kopioida tapahtumat.

### Product -taulukko

Product -taulukko sisältää seuraavat sarakkeet:

- Type: tyyppi
- Group: tuoteryhmä
- Product id: tuotteen tunniste
- Name: tuotteen nimi
- Stock balance: varastosaldo
- Unit: yksikkö
- Stock value: varaston arvo
- Cur.: käytettävä valuutta
- Avg. unit price: keskimääräinen yksikköhinta
- Last event: viimeisen varastotapahtuman päivämäärä
- Time: viimeisen varastuotapahtuman kellonaika
- Error: mahdollisesti tapahtuneen virheen kuvaus
- Info: lisätietoa
- Stock events: varastotapahtumat JSON-muodossa

### Stock -taulukko

Stock -taulukko sisältää seuraavat sarakkeet:

- Product: tuotteen tunniste
- Type: tyyppi
- Event date: varastoinnin päivämäärä
- Time: varastoinnin kellonaika
- Foreign purch. price: ulkomainen ostohinta
- Purchase price: ostohinta
- Cost price: omakustannushinta
- Currency: käytettävä valuutta
- Amount: varastossa oleva määrä
- Unit: yksikkö
- Info: näyttää saldon muutkosen ja saldon

### Sales order/ Purchase order -taulukot

Sales order- ja Purchase order -taulukot sisältävät seuraavat sarakkeet:

- Order: tilausnumero
- Row: tilausrivi
- Del.:
- Delivery date: toimituspäivä
- Product id: tuotteen tunniste
- Product group: tuoteryhmä
- Amount tuotteen määrä
- Unit: yksikkö
- Price vat 0%: hinta ilman arvonlisäveroa
- Description: kuvaus
- Info: lisätietoa

### Alareunan taulukko

Alareunan taulukko sisältää seuraavat sarakkeet:

- Event date: tapahtuman päivämäärä
- Type: tapahtuman tyyppi
- Remaining: jäljellä oleva määrä
- Used: käytetty määrä
- Unit: yksikkö
- Unit price: yksikköhinta
- Cur.: käytetty valuutta
- Rate: vaihtosuhde
- Cur.: kohdevaluutta
- Cur. unit price: valuutan yksikköhinta
- Price from: mistä hinta saadaan
- Time: tapahtuman aika
- Event amount: määrä tapahtumahetkellä
- Balance after event: saldo tapahtumahetken jälkeen
- Id: tapahtuman tunniste
