
# Stock

The stock page displays three lists: products allocated for reservations, materials for open jobs, and open work stages.

Additionally, the page includes a stock map that shows the location of products on the map.

## Stock Transactions

The page handles the receipt of materials to the stock. The data for receiving comes from purchase orders, which are displayed in the upper grid table. The center of the page shows the purchase order lines from the selected purchase order in the upper grid.

At the bottom of the page, you can see how a purchase order line is divided into packages and assigned to stock locations. The tool in the lower-left corner is used to split the order into packages. The packages are displayed in the center grid area at the bottom. The stock map, showing the locations of the packages, is visible in the lower-right corner.

The allocation of purchase order lines to stock locations at the bottom of the page proceeds as follows:

1. Select the purchase order line to process from the central grid area.
1. Verify the product’s material batch number.
1. The total quantity of the product is shown in the *Total Amount* field. The product may have two different units (e.g., a steel plate may have both mass and surface area).
1. Enter the number of packages to split the line into in the *Packet Count* field.
1. *Full Packet Size* indicates the size of one full package, calculated by dividing the *Total Amount* by the *Packet Count*.
1. *Last Packet Size* shows the size of the final package if the packages are unevenly split (i.e., the last package differs from the full packet size).
1. Click the *Create Row* button to generate package rows in the list displayed in the center at the bottom.
1. Assign packages to stock locations by selecting a package row and clicking a location on the stock map or selecting a stock location from the *Location* drop-down menu. Choose the transaction date in the *Target Date* field and save by clicking the *Save* button.

## Terms

AI chat question: What is correct name for ERP web page where you receive goods, put then in the shelves and deliver goods to customers? Stock, warehouse or something else?

### DeepSeek answer

The most accurate term for the ERP module or web page that handles receiving goods, storing them on shelves, and delivering them to customers is typically Warehouse Management (or Warehouse Management System - WMS). This module specifically focuses on:

- Receiving goods (inbound logistics),
- Storing/organizing inventory (putting items in shelves/locations),
- Picking/packing/shipping goods to customers (outbound logistics).

Common Terms in ERPs:

- Warehouse Management (WMS): Most precise term for physical stock and logistics.
- Inventory Management: Focuses on tracking stock levels but may overlap with warehouse functions.
- Stock Management: Less common in ERPs, but sometimes used interchangeably with inventory.
- Order Fulfillment: May cover delivery to customers but not always stock.

If the ERP combines these functions into one interface, it might use broader terms like "Inventory & Warehouse" or "Logistics Management". For clarity, Warehouse Management is the industry-standard term for physical handling of goods.

### Gemini answer

The correct name for an ERP web page that handles receiving, storing, and delivering goods depends on the specific functions it emphasizes and the terminology used within your organization. However, here's a breakdown of the most common terms and their nuances:

#### Warehouse Management

This is the most comprehensive term. A "Warehouse Management" page or module would typically encompass all aspects of receiving, storing, and shipping goods.
It implies a system that manages the physical space, inventory levels, and the flow of goods within a warehouse.
This is the most likely to be the correct answer.

#### Inventory Management

While related, "Inventory Management" focuses more on tracking the quantity and value of goods rather than the physical movement.
A page with this name might handle stock levels, valuations, and reporting, but it might not directly control the physical processes of receiving and shipping.

#### Stock Management

Similar to inventory management, "Stock Management" emphasizes the tracking of available goods.
This term is often used interchangeably with inventory management.

#### Stock Management

This term focus's on the physical act of storing the goods. It is less likely to be the main term used, as receiving and shipping are also key functions.

#### Logistics

This is a broader term that encompasses the entire supply chain, including transportation, warehousing, and distribution.
While a warehouse page is part of logistics, "Logistics" itself is too broad to be the specific name.
Receiving/Shipping:
These terms might be used for specific pages or sections within a larger warehouse management module. For example, you might have a "Receiving" page for incoming goods and a "Shipping" page for outgoing goods.
