// plugin/nc-calc-server/convert/product-convert.js

const convert = {}
export default convert

export function amountStock1ToStock2(pr, amount) {
	let newAmount = 0
	if (pr == null || pr.unit_multiplier == null) {
		newAmount = 0
	} else if (pr.unit_multiplier === 0) {
		newAmount = 0
	} else if (pr.unit_multiplier === 1) {
		newAmount = amount
	} else if (pr.unit_multiplier !== -1) {
		newAmount = amount / pr.unit_multiplier
	} else if (amount !== 0) {
		newAmount = 1 / amount
	}
	return newAmount
}
convert.amountStock1ToStock2 = amountStock1ToStock2

export function amountStock2ToStock1(pr, amount) {
	let newAmount = 0
	if (pr == null || pr.unit_multiplier == null) {
		newAmount = 0
	} else if (pr.unit_multiplier === 0) {
		newAmount = 0
	} else if (pr.unit_multiplier === 1) {
		newAmount = amount
	} else if (pr.unit_multiplier !== -1) {
		newAmount = amount * pr.unit_multiplier
	} else if (amount !== 0) {
		newAmount = 1 / amount
	}
	return newAmount
}
convert.amountStock2ToStock1 = amountStock2ToStock1

export function priceStock1ToStock2(product, price) {
	const prResult = {} // qry.queryJson('plugin/nc-calc-server/convert/product_arr_conversion_multiplier.json', { product_arr: [product] })
	if (prResult && prResult.error) {
		message.setWarning(state, prResult.error)
		return 0
	}
	const pr = prResult.data && prResult.data[0]
	if (pr == null) {
		message.setWarning(state, nc.l("product '%s' conversion table is missing", String(product)))
		return 0
	}
	let newPrice = 0
	if (pr.unit_multiplier == null) {
		newPrice = 0
	} else if (pr.unit_multiplier === 0) {
		newPrice = 0
	} else if (pr.unit_multiplier === 1) {
		newPrice = price
	} else if (pr.unit_multiplier !== -1) {
		newPrice = price * pr.unit_multiplier
	} else if (price !== 0) {
		newPrice = 1 / newPrice
	}
	return newPrice
}
convert.priceStock1ToStock2 = priceStock1ToStock2

export function priceStock2ToStock1(product, price) {
	const prResult = {} //  qry.queryJson('plugin/nc-calc-server/convert/product_arr_conversion_multiplier.json', { product_arr: [product] })
	if (prResult && prResult.error) {
		message.setWarning(state, prResult.error)
		return 0
	}
	const pr = prResult.data && prResult.data[0]
	if (pr == null) {
		message.setWarning(state, nc.l("product '%s' conversion table is missing", String(product)))
		return 0
	}
	let newPrice = 0
	if (pr.unit_multiplier == null) {
		newPrice = 0
	} else if (pr.unit_multiplier === 0) {
		newPrice = 0
	} else if (pr.unit_multiplier === 1) {
		newPrice = price
	} else if (pr.unit_multiplier !== -1) {
		newPrice = price / pr.unit_multiplier
	} else if (price !== 0) {
		newPrice = 1 / price
	}
	return newPrice
}
convert.priceStock2ToStock1 = priceStock2ToStock1

function amountInStockUnit14d(pr, amount, unit, productId, workNumberId, printError) {
	if (pr == null) {
		message.setWarning(state, nc.l("product '%s' amount conversion product is missing", String(product)))
		return amount
	}
	if (productId == null) {
		if (pr.product_id) {
			productId = pr.product_id
		} else if (pr['product_id - work']) {
			productId = pr['product_id - work']
		}
	}
	if (amount === 0) {
		return 0
	} else if (unit == null) {
		message.setWarning(state, nc.l("product '%s' amount conversion unit parameter is missing", String(product)))
		return amount
	}
	let value
	if (pr.stock_unit === unit) {
		value = amount
	} else if (pr.json_data && pr.json_data.stock_unit_2 === unit) {
		if (pr.unit_multiplier !== -1) {
			value = amount * pr.unit_multiplier
		} else {
			value = 1 / amount
		}
	} else if (pr.design_unit === unit) {
		if (pr.json_data && pr.json_data.design_unit_2 === pr.stock_unit) {
			if (pr.json_data.design_conversion_multiplier !== -1) {
				value = amount / pr.json_data.design_conversion_multiplier
			} else {
				value = 1 / amount
			}
		} else {
			if (pr.unit_multiplier !== -1) {
				value = amount * pr.unit_multiplier
			} else {
				value = 1 / amount
			}
		}
	} else if (pr.json_data && pr.json_data.design_unit_2 === unit) {
		let valueDesign1
		if (pr.json_data.design_conversion_multiplier !== -1) {
			valueDesign1 = amount * pr.json_data.design_conversion_multiplier
		} else {
			valueDesign1 = 1 / amount
		}
		if (pr.unit_multiplier !== -1) {
			value = valueDesign1 * pr.unit_multiplier
		} else if (valueDesign1 !== 0) {
			value = 1 / valueDesign1
		}
	} else {
		let err = nc.l(
			"product '%s' amount conversion failed, can't convert unit '%s' amount %.4f to product stock unit '%s', work '%s'",
			String(productId),
			String(unit),
			Number(amount),
			String(pr.stock_unit),
			String(workNumberId || '')
		)
		if (printError !== false) {
			err = message.setWarning(state, err)
		}
		return amount
	}
	return value
}

export function amountInStockUnit1(pr, amount, unit, productId, workNumberId, schema, printError) {
	if (schema === '4d') {
		return amountInStockUnit14d(pr, amount, unit, productId, workNumberId, printError)
	}
	return amount
}
convert.amountInStockUnit1 = amountInStockUnit1

export function amountDesign1ToStock1(pr, amount) {
	let newAmount = 0
	if (pr.unit_multiplier == null) {
		newAmount = 0
	} else if (pr.unit_multiplier === 0) {
		newAmount = 0
	} else if (pr.unit_multiplier !== -1) {
		newAmount = amount * pr.unit_multiplier
	} else if (amount !== 0) {
		newAmount = 1 / amount
	}
	return newAmount
}
convert.amountDesign1ToStock1 = amountDesign1ToStock1

// Convert from stock unit 1 to design unit 1
export function amountStock1ToDesign1(pr, amount) {
	let newAmount = 0
	if (pr == null || pr.unit_multiplier == null) {
		newAmount = 0
	} else if (pr.unit_multiplier === 0) {
		newAmount = 0
	} else if (pr.unit_multiplier === 1) {
		newAmount = amount
	} else if (pr.unit_multiplier !== -1) {
		newAmount = amount / pr.unit_multiplier
	} else if (amount !== 0) {
		newAmount = 1 / amount
	}
	return newAmount
}
convert.amountStock1ToDesign1 = amountStock1ToDesign1

// Convert from stock unit 1 to design unit 2
export function amountStock1ToDesign2(pr, amount) {
	let newAmount = 0
	if (pr == null || pr.json_data?.design_conversion_multiplier == null) {
		newAmount = 0
	} else if (pr.json_data.design_conversion_multiplier === 0) {
		newAmount = 0
	} else if (pr.json_data.design_conversion_multiplier === 1) {
		newAmount = amount
	} else if (pr.json_data.design_conversion_multiplier !== -1) {
		newAmount = amount / pr.json_data.design_conversion_multiplier
	} else if (amount !== 0) {
		newAmount = 1 / amount
	}
	return newAmount
}
convert.amountStock1ToDesign2 = amountStock1ToDesign2

// Convert from design unit 2 to stock unit 1
export function amountDesign2ToStock1(pr, amount) {
	let newAmount = 0
	if (pr == null || pr.json_data?.design_conversion_multiplier == null) {
		newAmount = 0
	} else if (pr.json_data.design_conversion_multiplier === 0) {
		newAmount = 0
	} else if (pr.json_data.design_conversion_multiplier === 1) {
		newAmount = amount
	} else if (pr.json_data.design_conversion_multiplier !== -1) {
		newAmount = amount * pr.json_data.design_conversion_multiplier
	} else if (amount !== 0) {
		newAmount = 1 / amount
	}
	return newAmount
}
convert.amountDesign2ToStock1 = amountDesign2ToStock1
